/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import leap.lang.Arrays2;
import leap.lang.Chars;
import leap.lang.http.Header;
import leap.lang.value.ImmutableNamedValue;
import leap.lang.value.NamedValue;

final class HeaderParser {
    private static final char PARAM_DELIMITER = ';';
    private static final char ELEM_DELIMITER = ',';
    private static final char[] ALL_DELIMITERS = new char[]{';', ','};

    HeaderParser() {
    }

    static List<Header.HeaderElement> parseElements(String value) {
        return HeaderParser.parseElements(value.toCharArray(), new Cursor(0, value.length()));
    }

    static List<Header.HeaderElement> parseElements(char[] buffer, Cursor cursor) {
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (cursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        ArrayList<Header.HeaderElement> elements = new ArrayList<Header.HeaderElement>();
        while (!cursor.atEnd()) {
            Header.HeaderElement element = HeaderParser.parseHeaderElement(buffer, cursor);
            if (element.getName().length() == 0 && element.getValue() == null) continue;
            elements.add(element);
        }
        return elements;
    }

    private static Header.HeaderElement parseHeaderElement(char[] buffer, Cursor cursor) {
        char ch;
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (cursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        NamedValue<String> nvp = HeaderParser.parseNameValuePair(buffer, cursor, ALL_DELIMITERS);
        Map<String, String> params = null;
        if (!cursor.atEnd() && (ch = buffer[cursor.pos - 1]) != ',') {
            params = HeaderParser.parseParameters(buffer, cursor);
        }
        return new Header.HeaderElement(nvp.getName(), (String)nvp.getValue(), params);
    }

    private static NamedValue<String> parseNameValuePair(char[] buffer, Cursor cursor, char[] delimiters) {
        char ch;
        int pos;
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (cursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        boolean terminated = false;
        int indexFrom = cursor.pos;
        int indexTo = cursor.upperBound;
        String name = null;
        for (pos = cursor.pos; pos < indexTo && (ch = buffer[pos]) != '='; ++pos) {
            if (!Arrays2.contains(delimiters, ch)) continue;
            terminated = true;
            break;
        }
        if (pos == indexTo) {
            terminated = true;
            name = Chars.substring(buffer, indexFrom, indexTo).trim();
        } else {
            name = Chars.substring(buffer, indexFrom, pos).trim();
            ++pos;
        }
        if (terminated) {
            cursor.updatePos(pos);
            return ImmutableNamedValue.of(name, null);
        }
        String value = null;
        int i1 = pos;
        boolean qouted = false;
        boolean escaped = false;
        while (pos < indexTo) {
            char ch2 = buffer[pos];
            if (ch2 == '\"' && !escaped) {
                boolean bl = qouted = !qouted;
            }
            if (!qouted && !escaped && Arrays2.contains(delimiters, ch2)) {
                terminated = true;
                break;
            }
            escaped = escaped ? false : qouted && ch2 == '\\';
            ++pos;
        }
        int i2 = pos;
        while (i1 < i2 && Character.isWhitespace(buffer[i1])) {
            ++i1;
        }
        while (i2 > i1 && Character.isWhitespace(buffer[i2 - 1])) {
            --i2;
        }
        if (i2 - i1 >= 2 && buffer[i1] == '\"' && buffer[i2 - 1] == '\"') {
            ++i1;
            --i2;
        }
        value = Chars.substring(buffer, i1, i2);
        if (terminated) {
            ++pos;
        }
        cursor.updatePos(pos);
        return ImmutableNamedValue.of(name, value);
    }

    private static Map<String, String> parseParameters(char[] buffer, Cursor cursor) {
        char ch;
        int pos;
        int indexTo = cursor.upperBound;
        for (pos = cursor.pos; pos < indexTo && Character.isWhitespace(ch = buffer[pos]); ++pos) {
        }
        cursor.updatePos(pos);
        if (cursor.atEnd()) {
            return new HashMap<String, String>();
        }
        Map<String, String> params = Header.HeaderElement.createParametersMap(null);
        while (!cursor.atEnd()) {
            NamedValue<String> param = HeaderParser.parseNameValuePair(buffer, cursor, ALL_DELIMITERS);
            params.put(param.getName(), (String)param.getValue());
            char ch2 = buffer[cursor.pos - 1];
            if (ch2 != ',') continue;
            break;
        }
        return params;
    }

    private static class Cursor {
        private final int lowerBound;
        private final int upperBound;
        private int pos;

        public Cursor(int lowerBound, int upperBound) {
            if (lowerBound < 0) {
                throw new IndexOutOfBoundsException("Lower bound cannot be negative");
            }
            if (lowerBound > upperBound) {
                throw new IndexOutOfBoundsException("Lower bound cannot be greater then upper bound");
            }
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.pos = lowerBound;
        }

        public void updatePos(int pos) {
            if (pos < this.lowerBound) {
                throw new IndexOutOfBoundsException("pos: " + pos + " < lowerBound: " + this.lowerBound);
            }
            if (pos > this.upperBound) {
                throw new IndexOutOfBoundsException("pos: " + pos + " > upperBound: " + this.upperBound);
            }
            this.pos = pos;
        }

        public boolean atEnd() {
            return this.pos >= this.upperBound;
        }
    }
}

