/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.http;

import java.util.Collections;
import java.util.Map;
import leap.lang.Strings;
import leap.lang.http.Header;

public class MimeType {
    public static final String WILDCARD_TYPE = "*";
    public static final String PARAM_CHARSET = "charset";
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;

    public MimeType() {
        this(WILDCARD_TYPE, WILDCARD_TYPE);
    }

    public MimeType(String type, String subtype) {
        this(type, subtype, null, null);
    }

    public MimeType(String type, String subtype, String charset) {
        this(type, subtype, charset, null);
    }

    public MimeType(String type, String subtype, Map<String, String> parameters) {
        this(type, subtype, null, parameters);
    }

    public MimeType(String type, String subtype, String charset, Map<String, String> parameters) {
        this.type = type == null ? WILDCARD_TYPE : type;
        this.subtype = subtype == null ? WILDCARD_TYPE : subtype;
        Map<String, String> parametersMap = Header.HeaderElement.createParametersMap(parameters);
        if (!Strings.isEmpty(charset)) {
            parametersMap.put(PARAM_CHARSET, charset);
        }
        this.parameters = Collections.unmodifiableMap(parametersMap);
    }

    public String getType() {
        return this.type;
    }

    public boolean isWildcardType() {
        return this.getType().equals(WILDCARD_TYPE);
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getMediaType() {
        return this.type + "/" + this.subtype;
    }

    public boolean isConcreteType() {
        return !this.isWildcardType() && !this.isWildcardSubtype();
    }

    public boolean isWildcardSubtype() {
        return this.getSubtype().equals(WILDCARD_TYPE);
    }

    public String getCharset() {
        return this.parameters.get(PARAM_CHARSET);
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public MimeType withCharset(String charset) {
        return new MimeType(this.type, this.subtype, charset, Header.HeaderElement.createParametersMap(this.parameters));
    }

    public boolean isCompatible(MimeType other) {
        return other != null && (this.type.equals(WILDCARD_TYPE) || other.type.equals(WILDCARD_TYPE) || this.type.equalsIgnoreCase(other.type) && (this.subtype.equals(WILDCARD_TYPE) || other.subtype.equals(WILDCARD_TYPE)) || this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MimeType)) {
            return false;
        }
        MimeType other = (MimeType)obj;
        return this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype) && this.parameters.equals(other.parameters);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.subtype.hashCode();
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb);
        return sb.toString();
    }

    protected void appendTo(StringBuilder sb) {
        sb.append(this.type);
        sb.append('/');
        sb.append(this.subtype);
        this.appendTo(this.parameters, sb);
    }

    private void appendTo(Map<String, String> map, StringBuilder sb) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(';');
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue());
        }
    }
}

