/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.http;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import leap.lang.Args;
import leap.lang.Strings;
import leap.lang.http.MimeType;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.lang.resource.Resource;
import leap.lang.resource.ResourceSet;
import leap.lang.resource.Resources;

public class MimeTypes {
    private static final Log log = LogFactory.get(MimeTypes.class);
    private static final FileTypeMap[] mimeTypeMaps = MimeTypes.loadMimeTypeMaps();
    public static final MimeType[] EMPTY_ARRAY = new MimeType[0];
    public static final String ALL = "*/*";
    public static final MimeType ALL_TYPE = MimeTypes.parse("*/*");
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_PLAIN_UTF8 = "text/plain;charset=UTF-8";
    public static final MimeType TEXT_PLAIN_TYPE = MimeTypes.parse("text/plain");
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_HTML_UTF8 = "text/html;charset=UTF-8";
    public static final MimeType TEXT_HTML_TYPE = MimeTypes.parse("text/html");
    public static final String TEXT_XML = "text/xml";
    public static final String TEXT_XML_UTF8 = "text/xml;charset=UTF-8";
    public static final MimeType TEXT_XML_TYPE = MimeTypes.parse("text/xml");
    public static final String TEXT_CSS = "text/css";
    public static final String TEXT_CSS_UTF8 = "text/css;charset=UTF-8";
    public static final MimeType TEXT_CSS_TYPE = MimeTypes.parse("text/css");
    public static final String TEXT_JAVASCRIPT = "text/javascript";
    public static final String TEXT_JAVASCRIPT_UTF8 = "text/javascript;charset=UTF-8";
    public static final MimeType TEXT_JAVASCRIPT_TYPE = MimeTypes.parse("text/javascript");
    public static final String APPLICATION_JAVASCRIPT = "application/javascript";
    public static final String APPLICATION_JAVASCRIPT_UTF8 = "application/javascript;charset=UTF-8";
    public static final MimeType APPLICATION_JAVASCRIPT_TYPE = MimeTypes.parse("application/javascript");
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_JSON_UTF8 = "application/json;charset=UTF-8";
    public static final MimeType APPLICATION_JSON_TYPE = MimeTypes.parse("application/json");
    public static final String APPLICATION_XML = "application/xml";
    public static final String APPLICATION_XML_UTF8 = "application/xml;charset=UTF-8";
    public static final MimeType APPLICATION_XML_TYPE = MimeTypes.parse("application/xml");
    public static final String APPLICATION_ATOM_XML = "application/atom+xml";
    public static final MimeType APPLICATION_ATOM_XML_TYPE = MimeTypes.parse("application/atom+xml");
    public static final String APPLICATION_XHTML_XML = "application/xhtml+xml";
    public static final MimeType APPLICATION_XHTML_XML_TYPE = MimeTypes.parse("application/xhtml+xml");
    public static final String APPLICATION_SVG_XML = "application/svg+xml";
    public static final MimeType APPLICATION_SVG_XML_TYPE = MimeTypes.parse("application/svg+xml");
    public static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final MimeType APPLICATION_FORM_URLENCODED_TYPE = MimeTypes.parse("application/x-www-form-urlencoded");
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final MimeType APPLICATION_OCTET_STREAM_TYPE = MimeTypes.parse("application/octet-stream");
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final MimeType MULTIPART_FORM_DATA_TYPE = MimeTypes.parse("multipart/form-data");

    public static boolean isText(String mimeType) {
        return Strings.startsWith(mimeType, "text/") || Strings.endsWith(mimeType, "javascript") || Strings.endsWith(mimeType, "json") || Strings.endsWith(mimeType, "xml");
    }

    public static MimeType parse(String mimeType) {
        int subIndex;
        Args.notEmpty(mimeType, "mimeType");
        String[] parts = Strings.split(mimeType, ';');
        String fullType = parts[0].trim();
        if ("*".equals(fullType)) {
            fullType = ALL;
        }
        if ((subIndex = fullType.indexOf(47)) == -1) {
            throw new IllegalArgumentException("mime type '" + mimeType + "' : does not contain '/'");
        }
        if (subIndex == fullType.length() - 1) {
            throw new IllegalArgumentException("mime type '" + mimeType + "' : does not contain subtype after '/'");
        }
        String type = fullType.substring(0, subIndex);
        String subtype = fullType.substring(subIndex + 1, fullType.length());
        if ("*".equals(type) && !"*".equals(subtype)) {
            throw new IllegalArgumentException("mime type '" + mimeType + "' : wildcard type is legal only in '*/*' (all mime types)");
        }
        LinkedHashMap<String, String> parameters = null;
        if (parts.length > 1) {
            parameters = new LinkedHashMap<String, String>(parts.length - 1);
            for (int i = 1; i < parts.length; ++i) {
                String parameter = parts[i];
                int eqIndex = parameter.indexOf(61);
                if (eqIndex == -1) continue;
                String attribute = parameter.substring(0, eqIndex);
                String value = parameter.substring(eqIndex + 1, parameter.length());
                parameters.put(attribute, value);
            }
        }
        try {
            return new MimeType(type, subtype, parameters);
        }
        catch (UnsupportedCharsetException ex) {
            throw new IllegalArgumentException("mime type '" + mimeType + "' : unsupported charset '" + ex.getCharsetName() + "'");
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("mime type '" + mimeType + "' : " + ex.getMessage());
        }
    }

    public static List<MimeType> parseList(String mimeTypes) {
        if (Strings.isEmpty(mimeTypes)) {
            return Collections.emptyList();
        }
        String[] tokens = mimeTypes.split(",\\s*");
        ArrayList<MimeType> result = new ArrayList<MimeType>(tokens.length);
        for (String token : tokens) {
            result.add(MimeTypes.parse(token));
        }
        return result;
    }

    public static String getMimeType(String filename) {
        String mimeType = null;
        for (FileTypeMap map : mimeTypeMaps) {
            mimeType = map.getContentType(filename);
            if (mimeType.equals(APPLICATION_OCTET_STREAM)) continue;
            return mimeType;
        }
        return APPLICATION_OCTET_STREAM;
    }

    private static FileTypeMap[] loadMimeTypeMaps() {
        InputStream internalFileTypeMapStream;
        LinkedList<Object> list = new LinkedList<Object>();
        FileTypeMap defaultFileTypeMap = FileTypeMap.getDefaultFileTypeMap();
        if (null != defaultFileTypeMap) {
            list.add(defaultFileTypeMap);
        }
        if (null != (internalFileTypeMapStream = MimeTypes.class.getResourceAsStream("mime.types"))) {
            list.addFirst(new MimetypesFileTypeMap(internalFileTypeMapStream));
        }
        ResourceSet externalMimeTypesResources = Resources.scan("classpath*:/META-INF/mime.types");
        for (Resource r : externalMimeTypesResources) {
            try {
                list.addFirst(new MimetypesFileTypeMap(r.getInputStream()));
            }
            catch (IOException e) {
                log.warn("Error reading mime types resource '{}'", r.getURLString(), e);
            }
        }
        return list.toArray(new FileTypeMap[0]);
    }

    protected MimeTypes() {
    }
}

