/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.http;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import leap.lang.Buildable;
import leap.lang.Emptiable;
import leap.lang.Strings;
import leap.lang.net.Urls;
import leap.lang.value.ImmutableEntry;

public class QueryStringBuilder
implements Buildable<String>,
Emptiable {
    private final String charset;
    private final List<Map.Entry<String, String>> params = new ArrayList<Map.Entry<String, String>>(5);

    public QueryStringBuilder() {
        this(null);
    }

    public QueryStringBuilder(String charset) {
        this.charset = null == charset ? "UTF-8" : charset;
    }

    public QueryStringBuilder add(String name, String v) {
        return this.add(name, v, true);
    }

    public QueryStringBuilder add(String name, String v, boolean urlEncode) {
        this.params.add(new ImmutableEntry<String, String>(name, urlEncode ? Urls.encode(v, this.charset) : v));
        return this;
    }

    public QueryStringBuilder addIfNotEmpty(String name, String v) {
        if (!Strings.isEmpty(v)) {
            this.add(name, v);
        }
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    @Override
    public String build() {
        StringBuilder qs = new StringBuilder();
        for (int i = 0; i < this.params.size(); ++i) {
            Map.Entry<String, String> p = this.params.get(i);
            if (i > 0) {
                qs.append('&');
            }
            String name = p.getKey();
            String value = p.getValue();
            qs.append(name).append('=').append(null == value ? "" : value);
        }
        return qs.toString();
    }

    public String toString() {
        return this.build();
    }
}

