/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import leap.lang.http.QueryString;
import leap.lang.http.QueryStringMap;
import leap.lang.net.Urls;

public class QueryStringParser {
    public static QueryString parse(String s) {
        if (null == s || s.length() == 0) {
            return QueryString.EMPTY;
        }
        QueryStringMap params = new QueryStringMap();
        QueryStringParser.parse(s, params);
        return params;
    }

    public static Map<String, List<String>> parseMap(String s) {
        if (null == s || s.length() == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        QueryStringParser.parse(s, params);
        return params;
    }

    private static void parse(String s, Map<String, List<String>> params) {
        int i;
        String name = null;
        int pos = 0;
        for (i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '=' && name == null) {
                if (pos != i) {
                    name = Urls.decode(s.substring(pos, i));
                }
                pos = i + 1;
                continue;
            }
            if (c != '&' && c != ';') continue;
            if (name == null && pos != i) {
                if (!QueryStringParser.addParam(params, Urls.decode(s.substring(pos, i)), "")) {
                    return;
                }
            } else if (name != null) {
                if (!QueryStringParser.addParam(params, name, Urls.decode(s.substring(pos, i)))) {
                    return;
                }
                name = null;
            }
            pos = i + 1;
        }
        if (pos != i) {
            if (name == null) {
                QueryStringParser.addParam(params, Urls.decode(s.substring(pos, i)), "");
            } else {
                QueryStringParser.addParam(params, name, Urls.decode(s.substring(pos, i)));
            }
        } else if (name != null) {
            QueryStringParser.addParam(params, name, "");
        }
    }

    private static boolean addParam(Map<String, List<String>> params, String name, String value) {
        List<String> values = params.get(name);
        if (values == null) {
            values = new ArrayList<String>(1);
            params.put(name, values);
        }
        values.add(value);
        return true;
    }

    protected QueryStringParser() {
    }
}

