/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.http.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import leap.lang.Strings;
import leap.lang.http.MimeType;
import leap.lang.http.MimeTypes;
import leap.lang.http.client.HttpClient;
import leap.lang.http.client.HttpHeaders;
import leap.lang.http.client.HttpResponse;
import leap.lang.http.exception.HttpIOException;

public abstract class AbstractHttpResponse<C extends HttpClient>
implements HttpResponse {
    protected C client;
    protected Integer status;
    protected HttpHeaders headers;
    protected MimeType contentType;
    protected byte[] bytes;

    public AbstractHttpResponse(C client) {
        this.client = client;
    }

    @Override
    public int getStatus() {
        if (null == this.status) {
            this.readHead();
        }
        return this.status;
    }

    @Override
    public HttpHeaders getHeaders() {
        if (null == this.headers) {
            this.readHead();
        }
        return this.headers;
    }

    @Override
    public MimeType getContentType() {
        String header;
        if (null == this.contentType && !Strings.isEmpty(header = this.getHeader("Content-Type"))) {
            this.contentType = MimeTypes.parse(header);
        }
        return this.contentType;
    }

    @Override
    public byte[] getBytes() throws HttpIOException {
        if (null == this.bytes) {
            this.readBody();
        }
        return this.bytes;
    }

    @Override
    public String getString() throws HttpIOException {
        return Strings.newString(this.getBytes(), this.charset());
    }

    @Override
    public InputStream getInputStream() throws HttpIOException {
        if (null == this.bytes) {
            try {
                return this.getUnderlyingInputStream();
            }
            catch (IOException e) {
                throw new HttpIOException(e);
            }
        }
        return new ByteArrayInputStream(this.bytes);
    }

    protected String charset() {
        MimeType mt = this.getContentType();
        if (null != mt && !Strings.isEmpty(mt.getCharset())) {
            return mt.getCharset();
        }
        return this.client.getDefaultCharset().name();
    }

    protected abstract void readHead();

    protected abstract InputStream getUnderlyingInputStream() throws IOException;

    protected void readBody() throws HttpIOException {
        try (InputStream is = this.getInputStream();){
            if (is == null) {
                this.bytes = new byte[0];
            } else {
                byte[] buffer = new byte[8192];
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                int bytes = is.read(buffer);
                while (bytes != -1) {
                    output.write(buffer, 0, bytes);
                    bytes = is.read(buffer);
                }
                this.bytes = output.toByteArray();
            }
        }
        catch (IOException e) {
            throw new HttpIOException(e);
        }
    }
}

