/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.http.client;

import java.io.InputStream;
import leap.lang.Strings;
import leap.lang.http.HTTP;
import leap.lang.http.client.HttpHandler;
import leap.lang.http.client.HttpResponse;

public interface HttpRequest {
    public boolean isAborted();

    public void abort();

    public HttpRequest setCookie(String var1, String var2);

    public HttpRequest setHeader(String var1, String var2);

    public HttpRequest addHeader(String var1, String var2);

    default public HttpRequest setContentType(String contentType) {
        return this.setHeader("Content-Type", contentType);
    }

    default public HttpRequest ajax() {
        return this.setHeader("X-Requested-With", "XMLHttpRequest");
    }

    default public HttpRequest json(String json) {
        this.setContentType("application/json;charset=UTF-8");
        return this.setBody(json);
    }

    default public HttpRequest setBody(String data) {
        return this.setBody(Strings.getBytesUtf8(data));
    }

    public HttpRequest setMethod(HTTP.Method var1);

    public HttpRequest setBody(byte[] var1);

    public HttpRequest setBody(InputStream var1);

    public HttpRequest addQueryParam(String var1, String var2);

    public HttpRequest addFormParam(String var1, String var2);

    default public HttpResponse get() {
        return this.send(HTTP.Method.GET);
    }

    default public HttpResponse post() {
        return this.send(HTTP.Method.POST);
    }

    default public HttpResponse send(HTTP.Method method) {
        return this.setMethod(method).send();
    }

    public HttpResponse send();

    public void send(HttpHandler var1);
}

