/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.BiConsumer;
import leap.lang.Arrays2;
import leap.lang.http.HTTP;
import leap.lang.http.MimeType;
import leap.lang.http.client.HttpHeaders;
import leap.lang.http.exception.HttpIOException;

public interface HttpResponse {
    default public boolean isOk() {
        return this.getStatus() == HTTP.SC_OK;
    }

    default public boolean is2xx() {
        return this.getStatus() >= 200 && this.getStatus() < 300;
    }

    default public boolean isNotFound() {
        return this.getStatus() == HTTP.SC_NOT_FOUND;
    }

    default public boolean isBadRequest() {
        return this.getStatus() == HTTP.SC_BAD_REQUEST;
    }

    default public void forEachHeaders(BiConsumer<String, String> func) {
        this.getHeaders().forEach(func);
    }

    public int getStatus();

    default public String getHeader(String name) {
        List<String> values = this.getHeaders().get(name);
        if (null == values || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    default public String[] getHeaderValues(String name) {
        List<String> values = this.getHeaders().get(name);
        if (null == values || values.isEmpty()) {
            return null;
        }
        return values.toArray(Arrays2.EMPTY_STRING_ARRAY);
    }

    public HttpHeaders getHeaders();

    public MimeType getContentType();

    default public String getCharset() {
        MimeType contentType = this.getContentType();
        return null == contentType ? null : contentType.getCharset();
    }

    public byte[] getBytes() throws HttpIOException;

    public String getString() throws HttpIOException;

    public InputStream getInputStream() throws HttpIOException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> T readInputStream(ContentReader<T> reader) throws HttpIOException {
        try (InputStream is = this.getInputStream();){
            T t = null == is ? null : (T)reader.read(is);
            return t;
        }
        catch (IOException e) {
            throw new HttpIOException(e);
        }
    }

    public static interface ContentReader<T> {
        public T read(InputStream var1) throws IOException;
    }
}

