/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.http.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import leap.lang.Args;
import leap.lang.Strings;
import leap.lang.Try;
import leap.lang.http.ContentTypes;
import leap.lang.http.HTTP;
import leap.lang.http.QueryStringBuilder;
import leap.lang.http.client.HttpHandler;
import leap.lang.http.client.HttpRequest;
import leap.lang.http.client.HttpResponse;
import leap.lang.http.client.JdkHttpClient;
import leap.lang.http.client.JdkHttpResponse;
import leap.lang.http.client.SimpleHttpHeaders;
import leap.lang.http.exception.HttpException;
import leap.lang.http.exception.HttpIOException;
import leap.lang.io.IO;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.lang.net.Urls;
import leap.lang.time.StopWatch;
import leap.lang.value.ImmutableNamedValue;
import leap.lang.value.NamedValue;

class JdkHttpRequest
implements HttpRequest {
    private static final Log log = LogFactory.get(JdkHttpRequest.class);
    protected final JdkHttpClient client;
    protected final String url;
    protected final boolean ssl;
    protected final Map<String, String> cookies = new LinkedHashMap<String, String>();
    protected final SimpleHttpHeaders headers = new SimpleHttpHeaders();
    protected final QueryStringBuilder queryParams = new QueryStringBuilder();
    protected final List<NamedValue<String>> formParams = new ArrayList<NamedValue<String>>();
    protected int connectTimeout;
    protected int readTimeout;
    protected Charset charset;
    protected InputStream content;
    protected HTTP.Method method;
    protected HttpURLConnection conn;
    private boolean form;
    private boolean aborted;

    protected JdkHttpRequest(JdkHttpClient client, String url) {
        Args.notEmpty(url, "url");
        Args.assertTrue(Strings.startsWithIgnoreCase(url, "http://") || Strings.startsWithIgnoreCase(url, "https://"), "The url must prefix with http:// or https://");
        this.client = client;
        this.url = url;
        this.ssl = Strings.startsWithIgnoreCase(url, "https://");
        this.connectTimeout = client.getDefaultConnectTimeout();
        this.readTimeout = client.getDefaultReadTimeout();
        this.charset = client.getDefaultCharset();
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public void abort() {
        if (null != this.conn) {
            this.aborted = true;
            this.conn.disconnect();
        }
    }

    @Override
    public HttpRequest setCookie(String name, String value) {
        Args.notEmpty(name, "name");
        this.cookies.put(name, value);
        return this;
    }

    @Override
    public HttpRequest setHeader(String name, String value) {
        Args.notEmpty(name, "name");
        this.headers.set(name, value);
        return this;
    }

    @Override
    public HttpRequest addHeader(String name, String value) {
        Args.notEmpty(name);
        this.headers.add(name, value);
        return this;
    }

    @Override
    public HttpRequest addQueryParam(String name, String value) {
        Args.notEmpty(name, "name");
        this.queryParams.add(name, value);
        return this;
    }

    @Override
    public HttpRequest addFormParam(String name, String value) {
        Args.notEmpty(name, "name");
        this.formParams.add(new ImmutableNamedValue<String>(name, value));
        return this;
    }

    @Override
    public HttpRequest setMethod(HTTP.Method method) {
        this.method = method;
        return this;
    }

    @Override
    public HttpRequest setBody(byte[] data) {
        Args.notNull(data, "data");
        this.content = new ByteArrayInputStream(data);
        return this;
    }

    @Override
    public HttpRequest setBody(InputStream is) {
        Args.notNull(is);
        this.content = is;
        return this;
    }

    @Override
    public HttpResponse get() {
        return this.send(HTTP.Method.GET);
    }

    @Override
    public HttpResponse post() {
        return this.send(HTTP.Method.POST);
    }

    @Override
    public HttpResponse send() {
        return this.doSend(this.method, this.initConnUrl(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(HttpHandler handler) {
        String connUrl = this.initConnUrl();
        handler.beforeRequest(this);
        try {
            handler.afterResponse(this, this.doSend(this.method, connUrl, false));
        }
        catch (Exception e) {
            try {
                if (!this.aborted) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new HttpException(e);
                }
                handler.afterAborted(this);
            }
            catch (Throwable throwable) {
                Try.catchAll(this.conn::disconnect);
                throw throwable;
            }
            Try.catchAll(this.conn::disconnect);
        }
        Try.catchAll(this.conn::disconnect);
    }

    protected String initConnUrl() {
        String connUrl = this.url;
        if (!this.queryParams.isEmpty()) {
            connUrl = Urls.appendQueryString(connUrl, this.queryParams.build());
        }
        if (null == this.method) {
            this.method = this.form || null != this.content ? HTTP.Method.POST : HTTP.Method.GET;
        }
        return connUrl;
    }

    protected boolean hasHeader(String name) {
        return this.headers.exists(name);
    }

    protected JdkHttpResponse doSend(HTTP.Method m, String connUrl, boolean immediately) {
        try {
            Object object;
            StopWatch sw;
            block34: {
                log.debug("Sending '{}' request to url : {}", new Object[]{m, connUrl});
                sw = StopWatch.startNew();
                URLConnection raw = new URL(connUrl).openConnection();
                if (!(raw instanceof HttpURLConnection)) {
                    throw new IllegalStateException("Url opens '" + raw.getClass().getName() + "' instead of expected HttpURLConnection");
                }
                this.conn = (HttpURLConnection)raw;
                this.setConnParams(this.conn, m);
                this.setHeaders(this.conn);
                this.setCookies(this.conn);
                if (m == HTTP.Method.POST || m == HTTP.Method.PUT || m == HTTP.Method.PATCH) {
                    this.conn.setDoOutput(true);
                    InputStream body = this.getBody();
                    object = null;
                    try {
                        if (null == body) break block34;
                        if (this.form && !this.hasHeader("Content-Type")) {
                            this.conn.setRequestProperty("Content-Type", ContentTypes.create("application/x-www-form-urlencoded", this.charset.name()));
                        }
                        log.debug("writing body content");
                        try (OutputStream out = this.conn.getOutputStream();){
                            IO.copy(body, out);
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (body != null) {
                            if (object != null) {
                                try {
                                    body.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                body.close();
                            }
                        }
                    }
                }
            }
            JdkHttpResponse response = new JdkHttpResponse(this.client, this, immediately);
            log.debug("Response used {}ms", sw.getElapsedMilliseconds());
            object = response;
            return object;
        }
        catch (MalformedURLException e) {
            throw new HttpException("Invalid url : " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new HttpIOException(e);
        }
        finally {
            if (immediately) {
                Try.catchAll(this.conn::disconnect);
            }
        }
    }

    protected void setConnParams(HttpURLConnection conn, HTTP.Method m) throws IOException {
        if (this.connectTimeout > 0) {
            conn.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout > 0) {
            conn.setReadTimeout(this.readTimeout);
        }
        conn.setRequestMethod(m.name());
        conn.setUseCaches(false);
        conn.setInstanceFollowRedirects(false);
    }

    protected void setHeaders(HttpURLConnection conn) throws IOException {
        this.headers.forEach((name, value) -> conn.addRequestProperty((String)name, (String)value));
    }

    protected void setCookies(HttpURLConnection conn) throws IOException {
        if (!this.cookies.isEmpty()) {
            StringBuilder header = new StringBuilder();
            int i = 0;
            for (Map.Entry<String, String> cookie : this.cookies.entrySet()) {
                if (i > 0) {
                    header.append(';');
                }
                ++i;
                header.append(cookie.getKey()).append('=').append(cookie.getValue());
            }
            conn.setRequestProperty("Cookie", header.toString());
        }
    }

    protected InputStream getBody() throws IOException {
        if (null != this.content) {
            return this.content;
        }
        if (!this.formParams.isEmpty()) {
            this.form = true;
            return this.getFormInputStream();
        }
        return null;
    }

    protected InputStream getFormInputStream() throws IOException {
        StringBuilder content = new StringBuilder();
        for (NamedValue<String> parameter : this.formParams) {
            String encodedName = Urls.encode(parameter.getName(), this.charset.name());
            String encodedValue = Urls.encode((String)parameter.getValue(), this.charset.name());
            if (content.length() > 0) {
                content.append('&');
            }
            content.append(encodedName);
            if (encodedValue == null) continue;
            content.append('=');
            content.append(encodedValue);
        }
        return new ByteArrayInputStream(Strings.getBytesUtf8(content.toString()));
    }
}

