/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import leap.lang.http.client.AbstractHttpResponse;
import leap.lang.http.client.JdkHttpClient;
import leap.lang.http.client.JdkHttpRequest;
import leap.lang.http.client.SimpleHttpHeaders;
import leap.lang.http.exception.HttpIOException;

class JdkHttpResponse
extends AbstractHttpResponse {
    protected final JdkHttpRequest request;
    protected final HttpURLConnection conn;

    public JdkHttpResponse(JdkHttpClient client, JdkHttpRequest request, boolean immediately) throws IOException {
        super(client);
        this.request = request;
        this.conn = request.conn;
        if (immediately) {
            this.readHead();
            this.readBody();
        }
    }

    @Override
    protected InputStream getUnderlyingInputStream() throws IOException {
        if (this.conn.getResponseCode() >= 400) {
            return this.conn.getErrorStream();
        }
        return this.conn.getInputStream();
    }

    @Override
    protected void readHead() {
        try {
            this.status = this.conn.getResponseCode();
            this.headers = new SimpleHttpHeaders();
            for (Map.Entry<String, List<String>> entry : this.conn.getHeaderFields().entrySet()) {
                String name = entry.getKey();
                if (null == name) continue;
                for (String value : entry.getValue()) {
                    this.headers.add(name, value);
                }
            }
        }
        catch (IOException e) {
            throw new HttpIOException(e);
        }
    }
}

