/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.http.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import leap.lang.collection.CaseInsensitiveMap;
import leap.lang.collection.WrappedCaseInsensitiveMap;
import leap.lang.http.client.HttpHeaders;

public class SimpleHttpHeaders
implements HttpHeaders {
    private static final List<String> EMPTY = Collections.emptyList();
    private final CaseInsensitiveMap<List<String>> map = WrappedCaseInsensitiveMap.create(new LinkedHashMap(5));

    @Override
    public boolean exists(String name) {
        return this.map.containsKey(name);
    }

    @Override
    public List<String> get(String name) {
        List values = (List)this.map.get(name);
        return null == values ? EMPTY : values;
    }

    @Override
    public void add(String name, String value) {
        this.mustGet(name).add(value);
    }

    @Override
    public void set(String name, String value) {
        List<String> values = this.mustGet(name);
        if (!values.isEmpty()) {
            values.clear();
        }
        values.add(value);
    }

    @Override
    public void forEach(BiConsumer<String, String> consumer) {
        if (this.map.isEmpty()) {
            return;
        }
        for (Map.Entry entry : this.map.entrySet()) {
            String name = (String)entry.getKey();
            for (String value : (List)entry.getValue()) {
                consumer.accept(name, value);
            }
        }
    }

    protected List<String> mustGet(String name) {
        ArrayList values = (ArrayList)this.map.get(name);
        if (null == values) {
            values = new ArrayList(1);
            this.map.put(name, values);
        }
        return values;
    }

    @Override
    public Map<String, List<String>> all() {
        return Collections.unmodifiableMap(this.map);
    }
}

