/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.http.client.apache;

import leap.lang.Disposable;
import leap.lang.Initializable;
import leap.lang.http.client.AbstractHttpClient;
import leap.lang.http.client.HttpRequest;
import leap.lang.http.client.apache.ApacheHttpRequest;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class ApacheHttpClient
extends AbstractHttpClient
implements Initializable,
Disposable {
    private static final Log log = LogFactory.get(ApacheHttpClient.class);
    private boolean init;
    private CloseableHttpClient httpClient;
    private RequestConfig requestConfig;
    private int maxConnectionTotal = 1000;
    private int maxConnectionPerRoute = 1000;
    private int bufferSize;

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public int getMaxConnectionTotal() {
        return this.maxConnectionTotal;
    }

    public void setMaxConnectionTotal(int maxConnectionTotal) {
        this.maxConnectionTotal = maxConnectionTotal;
    }

    public int getMaxConnectionPerRoute() {
        return this.maxConnectionPerRoute;
    }

    public void setMaxConnectionPerRoute(int maxConnectionPerRoute) {
        this.maxConnectionPerRoute = maxConnectionPerRoute;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public HttpRequest request(String url) {
        return new ApacheHttpRequest(this, url);
    }

    @Override
    public void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        this.requestConfig = this.initRequestConfig();
        this.httpClient = this.initHttpClient();
    }

    @Override
    public void dispose() throws Throwable {
        if (null != this.httpClient) {
            log.info("Close http client");
            this.init = false;
            this.httpClient.close();
        }
    }

    RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    protected RequestConfig initRequestConfig() {
        return RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setConnectTimeout(this.getDefaultConnectTimeout()).build();
    }

    protected CloseableHttpClient initHttpClient() {
        HttpClientBuilder cb = HttpClientBuilder.create();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(this.getDefaultRegistry());
        cm.setMaxTotal(this.maxConnectionTotal);
        cm.setDefaultMaxPerRoute(this.maxConnectionPerRoute);
        if (this.bufferSize > 0) {
            ConnectionConfig cc = ConnectionConfig.copy((ConnectionConfig)ConnectionConfig.DEFAULT).setBufferSize(this.bufferSize).build();
            cm.setDefaultConnectionConfig(cc);
        }
        cb.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler());
        cb.setConnectionManager((HttpClientConnectionManager)cm);
        cb.setDefaultRequestConfig(this.requestConfig);
        return cb.build();
    }

    protected Registry<ConnectionSocketFactory> getDefaultRegistry() {
        RegistryBuilder reg = RegistryBuilder.create();
        reg.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(SSL_CONTEXT, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        reg.register("https", (Object)sslSocketFactory);
        return reg.build();
    }
}

