/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.http.client.apache;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import leap.lang.http.HTTP;
import leap.lang.http.QueryStringBuilder;
import leap.lang.http.client.HttpHandler;
import leap.lang.http.client.HttpRequest;
import leap.lang.http.client.HttpResponse;
import leap.lang.http.client.apache.ApacheHttpClient;
import leap.lang.http.client.apache.ApacheHttpResponse;
import leap.lang.http.exception.HttpException;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.lang.net.Urls;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.execchain.RequestAbortedException;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.HeaderGroup;

public class ApacheHttpRequest
implements HttpRequest {
    private static final Log log = LogFactory.get(ApacheHttpRequest.class);
    private final ApacheHttpClient client;
    private final HttpClient rawClient;
    private final Charset charset;
    private final String uri;
    private final HeaderGroup headers = new HeaderGroup();
    private final QueryStringBuilder queryString = new QueryStringBuilder();
    private final List<NameValuePair> formParams = new ArrayList<NameValuePair>();
    private HTTP.Method method;
    private byte[] body;
    private InputStream inputStream;
    private HttpRequestBase request;
    private HttpEntity entity;

    ApacheHttpRequest(ApacheHttpClient client, String url) {
        this.client = client;
        this.rawClient = client.getHttpClient();
        this.charset = client.getDefaultCharset();
        this.uri = url;
    }

    @Override
    public boolean isAborted() {
        if (null != this.request) {
            return this.request.isAborted();
        }
        return false;
    }

    @Override
    public void abort() {
        if (null != this.request) {
            this.request.abort();
        }
    }

    @Override
    public HttpRequest setCookie(String name, String value) {
        return this;
    }

    @Override
    public HttpRequest setHeader(String name, String value) {
        this.headers.updateHeader((Header)new BasicHeader(name, value));
        return this;
    }

    @Override
    public HttpRequest addHeader(String name, String value) {
        this.headers.addHeader((Header)new BasicHeader(name, value));
        return this;
    }

    @Override
    public HttpRequest setBody(byte[] data) {
        this.body = data;
        return this;
    }

    @Override
    public HttpRequest setBody(InputStream is) {
        this.inputStream = is;
        return this;
    }

    @Override
    public HttpRequest addQueryParam(String name, String value) {
        this.queryString.add(name, value);
        return this;
    }

    @Override
    public HttpRequest addFormParam(String name, String value) {
        this.formParams.add((NameValuePair)new BasicNameValuePair(name, value));
        return this;
    }

    @Override
    public HttpRequest setMethod(HTTP.Method method) {
        this.method = method;
        return this;
    }

    @Override
    public HttpResponse send() {
        String url = this.buildRequestUrl();
        try {
            this.newRequest(url);
            log.debug("Sending '{}' request to '{}'...", new Object[]{this.method, url});
            org.apache.http.HttpResponse rawResponse = this.rawClient.execute((HttpUriRequest)this.request);
            ApacheHttpResponse response = new ApacheHttpResponse(this.client, this, rawResponse, true);
            if (log.isDebugEnabled()) {
                log.debug("Response result : [status={}, content-type='{}', content-length={}]", response.getStatus(), response.getContentType(), response.getContentLength());
            }
            return response;
        }
        catch (Exception e) {
            throw new HttpException("Error send http request : " + e.getMessage(), e);
        }
    }

    @Override
    public void send(HttpHandler handler) {
        String url = this.buildRequestUrl();
        try {
            this.newRequest(url);
            handler.beforeRequest(this);
            log.debug("Sending '{}' request to '{}'...", new Object[]{this.method, url});
            this.rawClient.execute((HttpUriRequest)this.request, r -> {
                ApacheHttpResponse response = new ApacheHttpResponse(this.client, this, r, false);
                if (log.isDebugEnabled()) {
                    log.debug("Handling response : [status={}, content-type='{}', content-length={}]", response.getStatus(), response.getContentType(), response.getContentLength());
                }
                handler.afterResponse(this, response);
                return null;
            });
        }
        catch (RequestAbortedException e) {
            handler.afterAborted(this);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new HttpException(e.getMessage(), e);
        }
        finally {
            this.release();
        }
    }

    public void release() {
        if (null != this.request) {
            this.request.releaseConnection();
        }
    }

    protected String buildRequestUrl() {
        String url = this.uri;
        if (!this.queryString.isEmpty()) {
            url = Urls.appendQueryString(url, this.queryString.build());
        }
        return url;
    }

    protected void initRequest() {
        if (null != this.body) {
            this.entity = new ByteArrayEntity(this.body);
        } else if (null != this.inputStream) {
            this.entity = new InputStreamEntity(this.inputStream);
        } else if (!this.formParams.isEmpty()) {
            this.entity = new UrlEncodedFormEntity(this.formParams, this.charset);
        }
        if (null == this.method) {
            this.method = null != this.entity ? HTTP.Method.POST : HTTP.Method.GET;
        }
    }

    protected HttpRequestBase newRequest(String url) {
        this.initRequest();
        if (this.method.equals((Object)HTTP.Method.GET)) {
            this.request = new HttpGet(url);
        }
        if (this.method.equals((Object)HTTP.Method.POST)) {
            this.request = new HttpPost(url);
        }
        if (this.method.equals((Object)HTTP.Method.PUT)) {
            this.request = new HttpPut(url);
        }
        if (this.method.equals((Object)HTTP.Method.DELETE)) {
            this.request = new HttpDelete(url);
        }
        if (this.method.equals((Object)HTTP.Method.PATCH)) {
            this.request = new HttpPatch(url);
        }
        if (this.method.equals((Object)HTTP.Method.HEAD)) {
            this.request = new HttpHead(url);
        }
        if (this.method.equals((Object)HTTP.Method.OPTIONS)) {
            this.request = new HttpOptions(url);
        }
        if (null == this.request) {
            throw new IllegalStateException("Http method '" + this.method.name() + "' not supported now");
        }
        Header[] headerArray = this.headers.getAllHeaders();
        if (null != headerArray && headerArray.length > 0) {
            this.request.setHeaders(headerArray);
        }
        if (null != this.entity) {
            this.entityEnclosingRequest().setEntity(this.entity);
        }
        return this.request;
    }

    protected HttpEntityEnclosingRequest entityEnclosingRequest() {
        if (!(this.request instanceof HttpEntityEnclosingRequest)) {
            throw new IllegalStateException("Http method '" + (Object)((Object)this.method) + "' does not supports request body");
        }
        return (HttpEntityEnclosingRequest)this.request;
    }
}

