/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.http.client.apache;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.BiConsumer;
import leap.lang.Arrays2;
import leap.lang.http.MimeType;
import leap.lang.http.MimeTypes;
import leap.lang.http.client.AbstractHttpResponse;
import leap.lang.http.client.HttpHeaders;
import leap.lang.http.client.HttpResponse;
import leap.lang.http.client.SimpleHttpHeaders;
import leap.lang.http.client.apache.ApacheHttpClient;
import leap.lang.http.client.apache.ApacheHttpRequest;
import org.apache.http.Header;
import org.apache.http.HttpEntity;

public class ApacheHttpResponse
extends AbstractHttpResponse
implements HttpResponse {
    private final ApacheHttpRequest request;
    private final org.apache.http.HttpResponse response;

    public ApacheHttpResponse(ApacheHttpClient client, ApacheHttpRequest request, org.apache.http.HttpResponse response, boolean immediately) throws IOException {
        super(client);
        this.request = request;
        this.response = response;
        if (immediately) {
            this.readHead();
            this.readBody();
        }
    }

    @Override
    public void forEachHeaders(BiConsumer<String, String> func) {
        Header[] headers = this.response.getAllHeaders();
        if (null != headers) {
            for (Header header : headers) {
                func.accept(header.getName(), header.getValue());
            }
        }
    }

    @Override
    public String getHeader(String name) {
        Object[] headers = this.response.getHeaders(name);
        return Arrays2.isEmpty(headers) ? null : headers[0].getValue();
    }

    @Override
    public String[] getHeaderValues(String name) {
        Header[] headers = this.response.getHeaders(name);
        if (null == headers || headers.length == 0) {
            return Arrays2.EMPTY_STRING_ARRAY;
        }
        String[] values = new String[headers.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = headers[i].getValue();
        }
        return values;
    }

    @Override
    public HttpHeaders getHeaders() {
        if (null == this.headers) {
            Header[] rawHeaders = this.response.getAllHeaders();
            this.headers = new SimpleHttpHeaders();
            if (null != this.headers) {
                for (Header header : rawHeaders) {
                    this.headers.add(header.getName(), header.getValue());
                }
            }
        }
        return this.headers;
    }

    @Override
    public MimeType getContentType() {
        if (null == this.contentType) {
            Header header;
            HttpEntity entity = this.response.getEntity();
            Header header2 = header = null == entity ? null : entity.getContentType();
            if (null != header) {
                this.contentType = MimeTypes.parse(header.getValue());
            }
        }
        return this.contentType;
    }

    @Override
    protected InputStream getUnderlyingInputStream() throws IOException {
        HttpEntity entity = this.response.getEntity();
        return null == entity ? null : entity.getContent();
    }

    @Override
    protected void readHead() {
        this.status = this.response.getStatusLine().getStatusCode();
    }

    public long getContentLength() {
        HttpEntity entity = this.response.getEntity();
        return null == entity ? -1L : entity.getContentLength();
    }
}

