/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.intercepting;

public class State {
    public static final int SC_CONTINUE = -1;
    public static final int SC_CONTINUE_PROCESSED = 0;
    public static final int SC_INTERCEPTED = 1;
    public static State CONTINUE = new State(-1);
    public static State CONTINUE_PROCESSED = new State(0);
    public static State INTERCEPTED = new State(1);
    protected final int status;

    public static boolean isContinue(State s) {
        return null == s || s.isContinue();
    }

    public static boolean isProcessed(State s) {
        return null != s && s.isProcessed();
    }

    public static boolean isIntercepted(State s) {
        return null != s && s.isIntercepted();
    }

    public boolean isContinue() {
        return this.status == -1 || this.status == 0;
    }

    public boolean isProcessed() {
        return this.status == 0;
    }

    public boolean isIntercepted() {
        return this.status == 1;
    }

    public int getStatus() {
        return this.status;
    }

    protected State(int status) {
        this.status = status;
    }
}

