/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.io;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadFactory;
import leap.lang.Exceptions;
import leap.lang.io.FileChangeObserver;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;

public class FileChangeMonitor
implements Runnable {
    private static final Log log = LogFactory.get(FileChangeMonitor.class);
    private static final long ERROR_SLEEP_INTERVAL = 10000L;
    protected final long interval;
    protected final List<FileChangeObserver> observers = new CopyOnWriteArrayList<FileChangeObserver>();
    protected Thread thread = null;
    protected ThreadFactory threadFactory;
    protected boolean daemon = true;
    protected volatile boolean running = false;
    protected boolean errorStop;

    public FileChangeMonitor() {
        this(10000L);
    }

    public FileChangeMonitor(long interval) {
        this.interval = interval;
    }

    public FileChangeMonitor(long interval, FileChangeObserver ... observers) {
        this(interval);
        if (observers != null) {
            for (FileChangeObserver observer : observers) {
                this.addObserver(observer);
            }
        }
    }

    public long getInterval() {
        return this.interval;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void setErrorStop(boolean errorStop) {
        this.errorStop = errorStop;
    }

    public synchronized void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public void addObserver(FileChangeObserver observer) {
        if (observer != null) {
            this.observers.add(observer);
        }
    }

    public void removeObserver(FileChangeObserver observer) {
        if (observer != null) {
            while (this.observers.remove(observer)) {
            }
        }
    }

    public Iterable<FileChangeObserver> getObservers() {
        return this.observers;
    }

    public synchronized void start() throws Exception {
        if (this.running) {
            throw new IllegalStateException("Monitor is already running");
        }
        for (FileChangeObserver observer : this.observers) {
            observer.initialize();
        }
        this.running = true;
        this.thread = this.threadFactory != null ? this.threadFactory.newThread(this) : new Thread(this);
        this.thread.setDaemon(this.daemon);
        this.thread.start();
    }

    public synchronized void stop() throws Exception {
        this.stop(this.interval);
    }

    public synchronized void stop(long stopInterval) throws Exception {
        if (!this.running) {
            throw new IllegalStateException("Monitor is not running");
        }
        this.running = false;
        try {
            this.thread.join(stopInterval);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        for (FileChangeObserver observer : this.observers) {
            observer.destroy();
        }
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                for (FileChangeObserver observer : this.observers) {
                    observer.checkAndNotify();
                }
            }
            catch (Throwable e) {
                if (this.errorStop) {
                    throw Exceptions.uncheck(e);
                }
                log.error("Error invoking observer.checkAndNotify", e);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.running) break;
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

