/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.io;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import leap.lang.Strings;
import leap.lang.io.FileChangeListener;
import leap.lang.io.FileInfo;
import leap.lang.io.Files;
import leap.lang.io.IOCase;
import leap.lang.io.IOComparators;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;

public class FileChangeObserver
implements Serializable {
    private static final long serialVersionUID = -8746490040819712555L;
    private static final Log log = LogFactory.get(FileChangeObserver.class);
    private final List<FileChangeListener> listeners = new CopyOnWriteArrayList<FileChangeListener>();
    private final FileInfo rootEntry;
    private final FileFilter fileFilter;
    private final Comparator<File> comparator;
    private boolean _initialized = false;

    public FileChangeObserver(String directoryName) {
        this(new File(directoryName));
    }

    public FileChangeObserver(String directoryName, FileFilter fileFilter) {
        this(new File(directoryName), fileFilter);
    }

    public FileChangeObserver(String directoryName, FileFilter fileFilter, IOCase caseSensitivity) {
        this(new File(directoryName), fileFilter, caseSensitivity);
    }

    public FileChangeObserver(File directory) {
        this(directory, (FileFilter)null);
    }

    public FileChangeObserver(File directory, FileFilter fileFilter) {
        this(directory, fileFilter, (IOCase)null);
    }

    public FileChangeObserver(File directory, FileFilter fileFilter, IOCase caseSensitivity) {
        this(new FileInfo(directory), fileFilter, caseSensitivity);
    }

    protected FileChangeObserver(FileInfo rootEntry, FileFilter fileFilter, IOCase caseSensitivity) {
        if (rootEntry == null) {
            throw new IllegalArgumentException("Root entry is missing");
        }
        if (rootEntry.getFile() == null) {
            throw new IllegalArgumentException("Root directory is missing");
        }
        this.rootEntry = rootEntry;
        this.fileFilter = fileFilter;
        this.comparator = caseSensitivity == null || caseSensitivity.equals(IOCase.SYSTEM) ? IOComparators.nameSystem() : (caseSensitivity.equals(IOCase.INSENSITIVE) ? IOComparators.nameInsensitive() : IOComparators.nameSensitive());
    }

    public File getDirectory() {
        return this.rootEntry.getFile();
    }

    public FileFilter getFilter() {
        return this.fileFilter;
    }

    public FileChangeObserver addListener(FileChangeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
        return this;
    }

    public FileChangeObserver removeListener(FileChangeListener listener) {
        if (listener != null) {
            while (this.listeners.remove(listener)) {
            }
        }
        return this;
    }

    public Iterable<FileChangeListener> getListeners() {
        return this.listeners;
    }

    public void destroy() throws Exception {
    }

    public void checkAndNotify() {
        block9: {
            if (!this._initialized) {
                this.initialize();
            }
            try {
                for (FileChangeListener fileChangeListener : this.listeners) {
                    fileChangeListener.onStart(this);
                }
                File rootFile = this.rootEntry.getFile();
                if (rootFile.exists()) {
                    this.checkAndNotify(this.rootEntry, this.rootEntry.getChildren(), this.listFiles(rootFile));
                } else if (this.rootEntry.isExists()) {
                    this.checkAndNotify(this.rootEntry, this.rootEntry.getChildren(), Files.EMPTY_FILE_ARRAY);
                }
                for (FileChangeListener listener : this.listeners) {
                    listener.onStop(this);
                }
            }
            catch (Throwable e) {
                boolean bl;
                log.info("Error on checkAndNotify : {}", e.getMessage(), e);
                boolean bl2 = false;
                for (FileChangeListener listener : this.listeners) {
                    if (!listener.onError(this, e)) continue;
                    bl = true;
                }
                if (bl) break block9;
                throw new RuntimeException(Strings.format("Error on checkAndNotify : {0}", e.getMessage()), e);
            }
        }
    }

    private void checkAndNotify(FileInfo parent, FileInfo[] previous, File[] files) {
        int c = 0;
        FileInfo[] current = files.length > 0 ? new FileInfo[files.length] : FileInfo.EMPTY_FILE_INFOS;
        for (FileInfo entry : previous) {
            while (c < files.length && this.comparator.compare(entry.getFile(), files[c]) > 0) {
                current[c] = this.createFileEntry(parent, files[c]);
                this.doCreate(current[c]);
                ++c;
            }
            if (c < files.length && this.comparator.compare(entry.getFile(), files[c]) == 0) {
                this.doMatch(entry, files[c]);
                this.checkAndNotify(entry, entry.getChildren(), this.listFiles(files[c]));
                current[c] = entry;
                ++c;
                continue;
            }
            this.checkAndNotify(entry, entry.getChildren(), Files.EMPTY_FILE_ARRAY);
            this.doDelete(entry);
        }
        while (c < files.length) {
            current[c] = this.createFileEntry(parent, files[c]);
            this.doCreate(current[c]);
            ++c;
        }
        parent.setChildren(current);
    }

    protected synchronized void initialize() {
        this.rootEntry.refresh(this.rootEntry.getFile());
        File[] files = this.listFiles(this.rootEntry.getFile());
        FileInfo[] children = files.length > 0 ? new FileInfo[files.length] : FileInfo.EMPTY_FILE_INFOS;
        for (int i = 0; i < files.length; ++i) {
            children[i] = this.createFileEntry(this.rootEntry, files[i]);
        }
        this.rootEntry.setChildren(children);
        this._initialized = true;
    }

    private FileInfo createFileEntry(FileInfo parent, File file) {
        FileInfo entry = parent.newChildInstance(file);
        entry.refresh(file);
        File[] files = this.listFiles(file);
        FileInfo[] children = files.length > 0 ? new FileInfo[files.length] : FileInfo.EMPTY_FILE_INFOS;
        for (int i = 0; i < files.length; ++i) {
            children[i] = this.createFileEntry(entry, files[i]);
        }
        entry.setChildren(children);
        return entry;
    }

    private void doCreate(FileInfo entry) {
        FileInfo[] children;
        for (FileChangeListener listener : this.listeners) {
            if (entry.isDirectory()) {
                listener.onDirectoryCreate(this, entry.getFile());
                continue;
            }
            listener.onFileCreate(this, entry.getFile());
        }
        for (FileInfo aChildren : children = entry.getChildren()) {
            this.doCreate(aChildren);
        }
    }

    private void doMatch(FileInfo entry, File file) {
        if (entry.refresh(file)) {
            for (FileChangeListener listener : this.listeners) {
                if (entry.isDirectory()) {
                    listener.onDirectoryChange(this, file);
                    continue;
                }
                listener.onFileChange(this, file);
            }
        }
    }

    private void doDelete(FileInfo entry) {
        for (FileChangeListener listener : this.listeners) {
            if (entry.isDirectory()) {
                listener.onDirectoryDelete(this, entry.getFile());
                continue;
            }
            listener.onFileDelete(this, entry.getFile());
        }
    }

    private File[] listFiles(File file) {
        File[] children = null;
        if (file.isDirectory()) {
            File[] fileArray = children = this.fileFilter == null ? file.listFiles() : file.listFiles(this.fileFilter);
        }
        if (children == null) {
            children = Files.EMPTY_FILE_ARRAY;
        }
        if (this.comparator != null && children.length > 1) {
            Arrays.sort(children, this.comparator);
        }
        return children;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("[file='");
        builder.append(this.getDirectory().getPath());
        builder.append('\'');
        if (this.fileFilter != null) {
            builder.append(", ");
            builder.append(this.fileFilter.toString());
        }
        builder.append(", listeners=");
        builder.append(this.listeners.size());
        builder.append("]");
        return builder.toString();
    }
}

