/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import leap.lang.io.FileFilter2;
import leap.lang.io.IOCase;

public class FileFilters {
    private static final FileFilter2 FILE = new FileFilter();
    private static final FileFilter2 DIR = new DirectoryFileFilter();
    private static final FileFilter2 HIDDEN = new HiddenFilter();
    private static final FileFilter2 VISIBLE = new NotFilter(HIDDEN);
    private static final FileFilter2 CAN_READ = new CanReadFilter();
    private static final FileFilter2 CANNOT_READ = new NotFilter(new CanReadFilter());
    private static final FileFilter2 CAN_WRITE = new CanWriteFilter();
    private static final FileFilter2 CANNOT_WRITE = new NotFilter(new CanWriteFilter());
    private static final FileFilter2 READONLY = new AndFilter(CAN_READ, CANNOT_WRITE);

    protected FileFilters() {
    }

    public static FileFilter2 isFile() {
        return FILE;
    }

    public static FileFilter2 isDirectory() {
        return DIR;
    }

    public static FileFilter2 isReadonly() {
        return READONLY;
    }

    public static FileFilter2 canRead() {
        return CAN_READ;
    }

    public static FileFilter2 canNotRead() {
        return CANNOT_READ;
    }

    public static FileFilter2 canWrite() {
        return CAN_WRITE;
    }

    public static FileFilter2 canNotWrite() {
        return CANNOT_WRITE;
    }

    public static FileFilter2 endsWith(String ... suffixes) {
        return new EndsWithFilter(suffixes);
    }

    public static FileFilter2 nameEquals(String ... names) {
        return new NameEqualsFilter(names);
    }

    public static FileFilter2 isHidden() {
        return HIDDEN;
    }

    public static FileFilter2 isVisible() {
        return VISIBLE;
    }

    public static FileFilter2 and(FileFilter2 ... filters) {
        return new AndFilter(filters);
    }

    public static FileFilter2 or(FileFilter2 ... filters) {
        return new OrFilter(filters);
    }

    public static FileFilter2 not(FileFilter2 filter) {
        return new NotFilter(filter);
    }

    static abstract class AbstractFileFilter
    implements FileFilter2 {
        AbstractFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return this.accept(file.getParentFile(), file.getName());
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.accept(new File(dir, name));
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    static class EndsWithFilter
    extends AbstractFileFilter {
        private final String[] suffixes;
        private final IOCase caseSensitivity;

        public EndsWithFilter(String suffix) {
            this(suffix, IOCase.SENSITIVE);
        }

        public EndsWithFilter(String suffix, IOCase caseSensitivity) {
            if (suffix == null) {
                throw new IllegalArgumentException("The suffix must not be null");
            }
            this.suffixes = new String[]{suffix};
            this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
        }

        public EndsWithFilter(String[] suffixes) {
            this(suffixes, IOCase.SENSITIVE);
        }

        public EndsWithFilter(String[] suffixes, IOCase caseSensitivity) {
            if (suffixes == null) {
                throw new IllegalArgumentException("The array of suffixes must not be null");
            }
            this.suffixes = new String[suffixes.length];
            System.arraycopy(suffixes, 0, this.suffixes, 0, suffixes.length);
            this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            for (String suffix : this.suffixes) {
                if (!this.caseSensitivity.checkEndsWith(name, suffix)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean accept(File file, String name) {
            for (String suffix : this.suffixes) {
                if (!this.caseSensitivity.checkEndsWith(name, suffix)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(super.toString());
            buffer.append("(");
            if (this.suffixes != null) {
                for (int i = 0; i < this.suffixes.length; ++i) {
                    if (i > 0) {
                        buffer.append(",");
                    }
                    buffer.append(this.suffixes[i]);
                }
            }
            buffer.append(")");
            return buffer.toString();
        }
    }

    static class FileFilter
    extends AbstractFileFilter {
        FileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isFile();
        }
    }

    static class OrFilter
    extends AbstractFileFilter {
        private final List<FileFilter2> filters;

        public OrFilter() {
            this.filters = new ArrayList<FileFilter2>();
        }

        public OrFilter(List<FileFilter2> fileFilters) {
            this.filters = fileFilters == null ? new ArrayList<FileFilter2>() : new ArrayList<FileFilter2>(fileFilters);
        }

        public OrFilter(FileFilter2 ... filters) {
            this.filters = filters == null ? new ArrayList<FileFilter2>() : Arrays.asList(filters);
        }

        @Override
        public boolean accept(File file) {
            for (FileFilter2 fileFilter : this.filters) {
                if (!fileFilter.accept(file)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean accept(File file, String name) {
            for (FileFilter2 fileFilter : this.filters) {
                if (!fileFilter.accept(file, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(super.toString());
            buffer.append("(");
            if (this.filters != null) {
                for (int i = 0; i < this.filters.size(); ++i) {
                    FileFilter2 filter;
                    if (i > 0) {
                        buffer.append(",");
                    }
                    buffer.append((filter = this.filters.get(i)) == null ? "null" : filter.toString());
                }
            }
            buffer.append(")");
            return buffer.toString();
        }
    }

    static class AndFilter
    extends AbstractFileFilter {
        private final List<FileFilter2> filters;

        public AndFilter() {
            this.filters = new ArrayList<FileFilter2>();
        }

        public AndFilter(List<FileFilter2> filters) {
            this.filters = filters == null ? new ArrayList<FileFilter2>() : new ArrayList<FileFilter2>(filters);
        }

        public AndFilter(FileFilter2 ... filters) {
            this.filters = filters == null ? new ArrayList<FileFilter2>() : Arrays.asList(filters);
        }

        @Override
        public boolean accept(File file) {
            if (this.filters.isEmpty()) {
                return false;
            }
            for (FileFilter2 fileFilter : this.filters) {
                if (fileFilter.accept(file)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean accept(File file, String name) {
            if (this.filters.isEmpty()) {
                return false;
            }
            for (FileFilter2 fileFilter : this.filters) {
                if (fileFilter.accept(file, name)) continue;
                return false;
            }
            return true;
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(super.toString());
            buffer.append("(");
            if (this.filters != null) {
                for (int i = 0; i < this.filters.size(); ++i) {
                    FileFilter2 filter;
                    if (i > 0) {
                        buffer.append(",");
                    }
                    buffer.append((filter = this.filters.get(i)) == null ? "null" : filter.toString());
                }
            }
            buffer.append(")");
            return buffer.toString();
        }
    }

    static class NotFilter
    extends AbstractFileFilter {
        private final FileFilter2 filter;

        public NotFilter(FileFilter2 filter) {
            if (filter == null) {
                throw new IllegalArgumentException("The filter must not be null");
            }
            this.filter = filter;
        }

        @Override
        public boolean accept(File file) {
            return !this.filter.accept(file);
        }

        @Override
        public boolean accept(File file, String name) {
            return !this.filter.accept(file, name);
        }

        @Override
        public String toString() {
            return super.toString() + "(" + this.filter.toString() + ")";
        }
    }

    static class NameEqualsFilter
    extends AbstractFileFilter {
        private final String[] names;
        private final IOCase caseSensitivity;

        public NameEqualsFilter(String name) {
            this(name, (IOCase)null);
        }

        public NameEqualsFilter(String name, IOCase caseSensitivity) {
            if (name == null) {
                throw new IllegalArgumentException("The name must not be null");
            }
            this.names = new String[]{name};
            this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
        }

        public NameEqualsFilter(String ... names) {
            this(names, (IOCase)null);
        }

        public NameEqualsFilter(String[] names, IOCase caseSensitivity) {
            if (names == null) {
                throw new IllegalArgumentException("The array of names must not be null");
            }
            this.names = new String[names.length];
            System.arraycopy(names, 0, this.names, 0, names.length);
            this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            for (String name2 : this.names) {
                if (!this.caseSensitivity.checkEquals(name, name2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean accept(File dir, String name) {
            for (String name2 : this.names) {
                if (!this.caseSensitivity.checkEquals(name, name2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(super.toString());
            buffer.append("(");
            if (this.names != null) {
                for (int i = 0; i < this.names.length; ++i) {
                    if (i > 0) {
                        buffer.append(",");
                    }
                    buffer.append(this.names[i]);
                }
            }
            buffer.append(")");
            return buffer.toString();
        }
    }

    static class DirectoryFileFilter
    extends AbstractFileFilter {
        DirectoryFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    }

    static class HiddenFilter
    extends AbstractFileFilter {
        HiddenFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isHidden();
        }
    }

    static class CanWriteFilter
    extends AbstractFileFilter {
        CanWriteFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.canWrite();
        }
    }

    static class CanReadFilter
    extends AbstractFileFilter {
        CanReadFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.canRead();
        }
    }
}

