/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import leap.lang.Args;
import leap.lang.Charsets;
import leap.lang.io.FileFilters;
import leap.lang.io.IO;
import leap.lang.net.Urls;
import leap.lang.path.Paths;

public class Files {
    public static final File[] EMPTY_FILE_ARRAY = new File[0];

    public static File fromUri(URI uri, String description) throws FileNotFoundException {
        Args.notNull(uri, "uri");
        if (!"file".equals(uri.getScheme())) {
            throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not reside in the file system: " + uri);
        }
        return new File(uri.getSchemeSpecificPart());
    }

    public static File fromUrl(URL url, String description) throws FileNotFoundException {
        Args.notNull(url, "url");
        if (!"file".equals(url.getProtocol())) {
            throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not reside in the file system: " + url);
        }
        try {
            return new File(Urls.toURI(url).getSchemeSpecificPart());
        }
        catch (URISyntaxException ex) {
            return new File(url.getFile());
        }
    }

    public static File createRelative(File parent, String relativePath) {
        if (parent.isDirectory()) {
            return new File(Paths.suffixWithSlash(parent.getAbsolutePath()) + Paths.prefixWithoutSlash(relativePath));
        }
        return new File(Paths.getDirPath(parent.getAbsolutePath()) + Paths.prefixWithoutSlash(relativePath));
    }

    public static File[] listDirs(File parent) {
        return parent.listFiles(FileFilters.isDirectory());
    }

    public static File[] listFiles(File dir, boolean deep) {
        return Files.listFiles(dir, deep, null);
    }

    public static File[] listFiles(File dir, boolean deep, FilenameFilter filter) {
        ArrayList<File> list = new ArrayList<File>();
        Files.listFiles(dir, deep, list, filter);
        return list.toArray(new File[list.size()]);
    }

    protected static void listFiles(final File dir, final boolean deep, final List<File> list, final FilenameFilter filter) {
        dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (null != filter && !filter.accept(dir, f.getName())) {
                    return false;
                }
                if (f.isFile()) {
                    list.add(f);
                } else if (deep && f.isDirectory()) {
                    Files.listFiles(f, deep, list, filter);
                }
                return false;
            }
        });
    }

    public static String readString(String path) {
        return IO.readString(new File(path), Charsets.defaultCharset());
    }

    public static String readString(String path, String encoding) {
        File file = new File(path);
        Charset charset = Charsets.forName(encoding);
        return IO.readString(file, charset);
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        return Files.openOutputStream(file, false);
    }

    public static FileOutputStream openOutputStream(File file, boolean append) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                throw new IOException("Directory '" + parent + "' could not be created");
            }
        }
        return new FileOutputStream(file, append);
    }

    public static boolean deleteQuietly(File file) {
        if (file == null) {
            return false;
        }
        try {
            if (file.isDirectory()) {
                Files.cleanDirectory(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return file.delete();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            Files.deleteDirectory(file);
        } else {
            boolean filePresent = file.exists();
            if (!file.delete()) {
                if (!filePresent) {
                    throw new FileNotFoundException("File does not exist: " + file);
                }
                String message = "Unable to delete file: " + file;
                throw new IOException(message);
            }
        }
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        if (!Files.isSymlink(directory)) {
            Files.cleanDirectory(directory);
        }
        if (!directory.delete()) {
            String message = "Unable to delete directory " + directory + ".";
            throw new IOException(message);
        }
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + directory);
        }
        IOException exception = null;
        for (File file : files) {
            try {
                Files.forceDelete(file);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static boolean isSymlink(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        if (Paths.isSystemWindows()) {
            return false;
        }
        File fileInCanonicalDir = null;
        if (file.getParent() == null) {
            fileInCanonicalDir = file;
        } else {
            File canonicalDir = file.getParentFile().getCanonicalFile();
            fileInCanonicalDir = new File(canonicalDir, file.getName());
        }
        return !fileInCanonicalDir.getCanonicalFile().equals(fileInCanonicalDir.getAbsoluteFile());
    }

    public static void touch(File file) throws IOException {
        boolean success;
        if (!file.exists()) {
            FileOutputStream out = Files.openOutputStream(file);
            IO.close(out);
        }
        if (!(success = file.setLastModified(System.currentTimeMillis()))) {
            throw new IOException("Unable to set the last modification time for " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(String filename, byte[] data) throws IOException {
        FileOutputStream out = null;
        try {
            File file = new File(filename);
            File dir = Files.getDirecotry(file);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            out = new FileOutputStream(file);
            ((OutputStream)out).write(data);
            out.flush();
        }
        catch (Throwable throwable) {
            IO.close(out);
            throw throwable;
        }
        IO.close(out);
    }

    public static boolean mkdirs(File file) {
        String folder = Paths.getDirPath(file.getAbsolutePath());
        return new File(folder).mkdirs();
    }

    private static File getDirecotry(File file) {
        String path = file.getParent();
        if (null != path) {
            return new File(path);
        }
        return null;
    }

    protected Files() {
    }
}

