/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.io;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import leap.lang.Charsets;
import leap.lang.Exceptions;
import leap.lang.annotation.Nullable;
import leap.lang.exception.NestedIOException;

public class IO {
    private static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static String tmpdir() {
        String path = System.getProperty("java.io.tmpdir");
        if (!path.endsWith(File.separator)) {
            return path + File.separator;
        }
        return path;
    }

    public static Reader createReader(File file) throws NestedIOException {
        return IO.createReader(file, Charsets.defaultCharset());
    }

    public static Reader createReader(File file, Charset charset) throws NestedIOException {
        try {
            return new InputStreamReader((InputStream)new FileInputStream(file), charset);
        }
        catch (IOException e) {
            throw Exceptions.wrap(e);
        }
    }

    public static Writer createWriter(File file) throws NestedIOException {
        return IO.createWriter(file, Charsets.defaultCharset());
    }

    public static Writer createWriter(File file, Charset charset) throws NestedIOException {
        try {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset);
        }
        catch (IOException e) {
            throw Exceptions.wrap(e);
        }
    }

    public static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static byte[] readByteArray(InputStream input) throws NestedIOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IO.copy(input, output);
        return output.toByteArray();
    }

    public static byte[] readByteArrayAndClose(InputStream is) {
        try {
            byte[] byArray = IO.readByteArray(is);
            return byArray;
        }
        finally {
            IO.close(is);
        }
    }

    public static byte[] readByteArray(File file) {
        byte[] byArray;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byArray = IO.readByteArray(in);
        }
        catch (IOException e) {
            try {
                throw Exceptions.wrap(e);
            }
            catch (Throwable throwable) {
                IO.close(in);
                throw throwable;
            }
        }
        IO.close(in);
        return byArray;
    }

    public static byte[] readByteArray(Reader reader) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(out);
        try {
            IO.copy(reader, (Writer)writer);
            writer.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw Exceptions.wrap(e);
        }
        finally {
            IO.close(writer);
        }
    }

    public static byte[] readByteArrayAndClose(Reader reader) {
        try {
            byte[] byArray = IO.readByteArray(reader);
            return byArray;
        }
        finally {
            IO.close(reader);
        }
    }

    public static byte[] readByteArray(InputStream input, long size) throws NestedIOException {
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size cannot be greater than Integer max value: " + size);
        }
        return IO.readByteArray(input, (int)size);
    }

    public static byte[] readByteArray(InputStream input, int size) throws NestedIOException {
        if (size < 0) {
            throw new IllegalArgumentException("Size must be equal or greater than zero: " + size);
        }
        if (size == 0) {
            return new byte[0];
        }
        byte[] data = new byte[size];
        try {
            int offset;
            int readed;
            for (offset = 0; offset < size && (readed = input.read(data, offset, size - offset)) != -1; offset += readed) {
            }
            if (offset != size) {
                throw new IOException("Unexpected readed size. current: " + offset + ", excepted: " + size);
            }
        }
        catch (IOException e) {
            throw Exceptions.wrap(e);
        }
        return data;
    }

    public static String readString(File file, Charset encoding) throws NestedIOException {
        String string;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            string = IO.readString(fis, encoding);
        }
        catch (IOException e) {
            try {
                throw Exceptions.wrap(e);
            }
            catch (Throwable throwable) {
                IO.close(fis);
                throw throwable;
            }
        }
        IO.close(fis);
        return string;
    }

    public static String readString(InputStream input, Charset encoding) throws NestedIOException {
        StringWriter sw = new StringWriter();
        IO.copy(input, (Writer)sw, encoding);
        return sw.toString();
    }

    public static String readStringAndClose(InputStream is, Charset charset) {
        try {
            String string = IO.readString(is, charset);
            return string;
        }
        finally {
            IO.close(is);
        }
    }

    public static String readString(Reader input) throws NestedIOException {
        StringWriter sw = new StringWriter();
        IO.copy(input, (Writer)sw);
        return sw.toString();
    }

    public static String readStringAndClose(Reader reader) {
        try {
            String string = IO.readString(reader);
            return string;
        }
        finally {
            IO.close(reader);
        }
    }

    public static void writeString(File file, String string) {
        IO.writeString(file, string, Charsets.defaultCharset());
    }

    public static void writeString(File file, String string, Charset encoding) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            IO.writeString(out, string, encoding);
        }
        catch (IOException e) {
            try {
                throw Exceptions.wrap(e);
            }
            catch (Throwable throwable) {
                IO.close(out);
                throw throwable;
            }
        }
        IO.close(out);
    }

    public static void writeString(OutputStream out, String string, Charset encoding) {
        byte[] data = string.getBytes(encoding);
        try {
            out.write(data);
        }
        catch (IOException e) {
            throw Exceptions.wrap(e);
        }
    }

    public static long copy(InputStream input, OutputStream output) throws NestedIOException {
        return IO.copy(input, output, new byte[4096]);
    }

    public static long copy(InputStream input, OutputStream output, byte[] buffer) throws NestedIOException {
        long count = 0L;
        int n = 0;
        try {
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
        }
        catch (IOException e) {
            throw Exceptions.wrap(e);
        }
        return count;
    }

    public static void copy(InputStream input, Writer output) throws NestedIOException {
        IO.copy(input, output, Charset.defaultCharset());
    }

    public static void copy(InputStream input, Writer output, @Nullable Charset encoding) throws NestedIOException {
        InputStreamReader in = new InputStreamReader(input, Charsets.get(encoding));
        IO.copy(in, output);
    }

    public static void copy(InputStream input, Writer output, String encoding) throws NestedIOException {
        IO.copy(input, output, Charsets.get(encoding));
    }

    public static long copy(Reader input, Writer output) throws NestedIOException {
        return IO.copy(input, output, new char[4096]);
    }

    public static long copy(Reader input, Writer output, char[] buffer) throws NestedIOException {
        long count = 0L;
        int n = 0;
        try {
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
        }
        catch (IOException e) {
            throw Exceptions.wrap(e);
        }
        return count;
    }

    protected IO() {
    }
}

