/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.io;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import leap.lang.io.IOCase;

public class IOComparators {
    private static final Comparator<File> NAME_COMPARATOR = new NameFileComparator();
    private static final Comparator<File> NAME_REVERSE = new ReverseComparator(NAME_COMPARATOR);
    private static final Comparator<File> NAME_INSENSITIVE_COMPARATOR = new NameFileComparator(IOCase.INSENSITIVE);
    private static final Comparator<File> NAME_INSENSITIVE_REVERSE = new ReverseComparator(NAME_INSENSITIVE_COMPARATOR);
    private static final Comparator<File> NAME_SYSTEM_COMPARATOR = new NameFileComparator(IOCase.SYSTEM);
    private static final Comparator<File> NAME_SYSTEM_REVERSE = new ReverseComparator(NAME_SYSTEM_COMPARATOR);

    public static Comparator<File> nameSensitive() {
        return NAME_COMPARATOR;
    }

    public static Comparator<File> nameSensitiveReverse() {
        return NAME_REVERSE;
    }

    public static Comparator<File> nameInsensitive() {
        return NAME_INSENSITIVE_COMPARATOR;
    }

    public static Comparator<File> nameInsensitiveReverse() {
        return NAME_INSENSITIVE_REVERSE;
    }

    public static Comparator<File> nameSystem() {
        return NAME_SYSTEM_COMPARATOR;
    }

    public static Comparator<File> nameSystemReverse() {
        return NAME_SYSTEM_REVERSE;
    }

    static abstract class AbstractFileComparator
    implements Comparator<File> {
        AbstractFileComparator() {
        }

        public File[] sort(File ... files) {
            if (files != null) {
                Arrays.sort(files, this);
            }
            return files;
        }

        public List<File> sort(List<File> files) {
            if (files != null) {
                Collections.sort(files, this);
            }
            return files;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    static class ReverseComparator
    extends AbstractFileComparator {
        private final Comparator<File> delegate;

        public ReverseComparator(Comparator<File> delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException("Delegate comparator is missing");
            }
            this.delegate = delegate;
        }

        @Override
        public int compare(File file1, File file2) {
            return this.delegate.compare(file2, file1);
        }

        @Override
        public String toString() {
            return super.toString() + "[" + this.delegate.toString() + "]";
        }
    }

    static class NameFileComparator
    extends AbstractFileComparator {
        private final IOCase caseSensitivity;

        public NameFileComparator() {
            this.caseSensitivity = IOCase.SENSITIVE;
        }

        public NameFileComparator(IOCase caseSensitivity) {
            this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
        }

        @Override
        public int compare(File file1, File file2) {
            return this.caseSensitivity.checkCompareTo(file1.getName(), file2.getName());
        }

        @Override
        public String toString() {
            return super.toString() + "[caseSensitivity=" + this.caseSensitivity + "]";
        }
    }
}

