/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import leap.lang.jdbc.CallableStatementProxy;
import leap.lang.jdbc.ConnectionWrapper;
import leap.lang.jdbc.DatabaseMetadataProxy;
import leap.lang.jdbc.PreparedStatementProxy;
import leap.lang.jdbc.StatementProxy;

public abstract class ConnectionProxy
extends ConnectionWrapper {
    protected Exception stackTraceExceptionOnOpen;
    protected boolean statementStackTrace;
    protected static ThreadLocal<Boolean> printThreadDump = ThreadLocal.withInitial(() -> true);

    public static void disabledPrintThreadDump() {
        printThreadDump.set(false);
    }

    public static void resetPrintThreadDump() {
        printThreadDump.set(true);
    }

    public static boolean printThreadDumpEnable() {
        return printThreadDump.get();
    }

    public ConnectionProxy(Connection conn) {
        this(conn, false);
    }

    public ConnectionProxy(Connection conn, boolean stackTraceOnOpen) {
        super(conn);
        this.stackTraceExceptionOnOpen = stackTraceOnOpen ? new Exception("") : null;
    }

    public final Connection wrapped() {
        return this.conn;
    }

    public final boolean hasStackTraceOnOpen() {
        return null != this.stackTraceExceptionOnOpen;
    }

    public StackTraceElement[] getStackTraceOnOpen() {
        return null == this.stackTraceExceptionOnOpen ? null : this.getStackTrace(this.stackTraceExceptionOnOpen);
    }

    @Override
    public final DatabaseMetaData getMetaData() throws SQLException {
        return this.proxyOfMetadata(this.conn.getMetaData());
    }

    @Override
    public final Statement createStatement() throws SQLException {
        return this.proxyOfStatement(this.conn.createStatement());
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.proxyOfStatement(this.conn.createStatement(resultSetType, resultSetConcurrency));
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.proxyOfStatement(this.conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.proxyOfPreparedStatement(this.conn.prepareStatement(sql), sql);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.proxyOfPreparedStatement(this.conn.prepareStatement(sql, autoGeneratedKeys), sql);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.proxyOfPreparedStatement(this.conn.prepareStatement(sql, columnIndexes), sql);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.proxyOfPreparedStatement(this.conn.prepareStatement(sql, columnNames), sql);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.proxyOfPreparedStatement(this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency), sql);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.proxyOfPreparedStatement(this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
    }

    @Override
    public final CallableStatement prepareCall(String sql) throws SQLException {
        return this.proxyOfCallableStatement(this.conn.prepareCall(sql), sql);
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.proxyOfCallableStatement(this.conn.prepareCall(sql, resultSetType, resultSetConcurrency), sql);
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.proxyOfCallableStatement(this.conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
    }

    protected Statement proxyOf(Statement stmt) {
        if (stmt instanceof PreparedStatement) {
            return this.proxyOfPreparedStatement((PreparedStatement)stmt, null);
        }
        if (stmt instanceof CallableStatement) {
            return this.proxyOfCallableStatement((CallableStatement)stmt, null);
        }
        return this.proxyOfStatement(stmt);
    }

    protected DatabaseMetadataProxy proxyOfMetadata(DatabaseMetaData md) {
        return new DatabaseMetadataProxy<ConnectionProxy>(this, md);
    }

    protected StatementProxy proxyOfStatement(Statement stmt) {
        return new StatementProxy<ConnectionProxy>(this, stmt, this.statementStackTrace);
    }

    protected PreparedStatementProxy proxyOfPreparedStatement(PreparedStatement ps, String sql) {
        return new PreparedStatementProxy<ConnectionProxy>(this, ps, sql, this.statementStackTrace);
    }

    protected CallableStatementProxy proxyOfCallableStatement(CallableStatement cs, String sql) {
        return new CallableStatementProxy<ConnectionProxy>(this, cs, sql, this.statementStackTrace);
    }

    protected void endExecuteStatement(StatementProxy stmt) {
    }

    protected void closeStatement(StatementProxy stmt) throws SQLException {
        stmt.wrapped().close();
    }

    protected StackTraceElement[] getStackTrace(Exception e) {
        return e.getStackTrace();
    }
}

