/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import leap.lang.jdbc.ConnectionProxy;
import leap.lang.jdbc.DatabaseMetaDataWrapper;
import leap.lang.jdbc.ResultSetProxy;

public class DatabaseMetadataProxy<T extends ConnectionProxy>
extends DatabaseMetaDataWrapper {
    protected final T conn;

    public DatabaseMetadataProxy(T conn, DatabaseMetaData md) {
        super(md);
        this.conn = conn;
    }

    @Override
    public final Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public final ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return this.proxyOfResultSet(this.md.getProcedures(catalog, schemaPattern, procedureNamePattern));
    }

    @Override
    public final ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return this.proxyOfResultSet(this.md.getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern));
    }

    @Override
    public final ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        return this.proxyOfResultSet(this.md.getTables(catalog, schemaPattern, tableNamePattern, types));
    }

    @Override
    public final ResultSet getSchemas() throws SQLException {
        return this.proxyOfResultSet(this.md.getSchemas());
    }

    @Override
    public final ResultSet getCatalogs() throws SQLException {
        return this.proxyOfResultSet(this.md.getCatalogs());
    }

    @Override
    public final ResultSet getTableTypes() throws SQLException {
        return this.proxyOfResultSet(this.md.getTableTypes());
    }

    @Override
    public final ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.proxyOfResultSet(this.md.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern));
    }

    @Override
    public final ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return this.proxyOfResultSet(this.md.getColumnPrivileges(catalog, schema, table, columnNamePattern));
    }

    @Override
    public final ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.proxyOfResultSet(this.md.getTablePrivileges(catalog, schemaPattern, tableNamePattern));
    }

    @Override
    public final ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return this.proxyOfResultSet(this.md.getBestRowIdentifier(catalog, schema, table, scope, nullable));
    }

    @Override
    public final ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return this.proxyOfResultSet(this.md.getVersionColumns(catalog, schema, table));
    }

    @Override
    public final ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        return this.proxyOfResultSet(this.md.getPrimaryKeys(catalog, schema, table));
    }

    @Override
    public final ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.proxyOfResultSet(this.md.getImportedKeys(catalog, schema, table));
    }

    @Override
    public final ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.proxyOfResultSet(this.md.getExportedKeys(catalog, schema, table));
    }

    @Override
    public final ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.proxyOfResultSet(this.md.getCrossReference(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable));
    }

    @Override
    public final ResultSet getTypeInfo() throws SQLException {
        return this.proxyOfResultSet(this.md.getTypeInfo());
    }

    @Override
    public final ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return this.proxyOfResultSet(this.md.getIndexInfo(catalog, schema, table, unique, approximate));
    }

    @Override
    public final ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return this.proxyOfResultSet(this.md.getUDTs(catalog, schemaPattern, typeNamePattern, types));
    }

    @Override
    public final ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return this.proxyOfResultSet(this.md.getSuperTypes(catalog, schemaPattern, typeNamePattern));
    }

    @Override
    public final ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.proxyOfResultSet(this.md.getSuperTables(catalog, schemaPattern, tableNamePattern));
    }

    @Override
    public final ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return this.proxyOfResultSet(this.md.getAttributes(catalog, schemaPattern, typeNamePattern, attributeNamePattern));
    }

    @Override
    public final ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return this.proxyOfResultSet(this.md.getSchemas(catalog, schemaPattern));
    }

    @Override
    public final ResultSet getClientInfoProperties() throws SQLException {
        return this.proxyOfResultSet(this.md.getClientInfoProperties());
    }

    @Override
    public final ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return this.proxyOfResultSet(this.md.getFunctions(catalog, schemaPattern, functionNamePattern));
    }

    @Override
    public final ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return this.proxyOfResultSet(this.md.getFunctionColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern));
    }

    @Override
    public final ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.proxyOfResultSet(this.md.getPseudoColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern));
    }

    protected ResultSet proxyOfResultSet(ResultSet rs) throws SQLException {
        return new ResultSetProxy(rs.getStatement(), rs);
    }
}

