/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import leap.lang.Strings;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.lang.net.Urls;

public class JDBC {
    private static final Log log = LogFactory.get(JDBC.class);
    public static final char PARAMETER_PLACEHOLDER_CHAR = '?';
    public static final String PARAMETER_PLACEHOLDER_STRING = "?";

    public static void closeConnection(Connection connection) {
        if (null != connection) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.warn("Error closing connection : " + e.getMessage(), e);
            }
        }
    }

    public static void closeStatementOnly(Statement statement) {
        if (null != statement) {
            try {
                statement.close();
            }
            catch (Throwable e) {
                log.warn("Error closing statement : {} ", e.getMessage(), e);
            }
        }
    }

    public static void closeStatementAndConnection(Statement statement) {
        if (null != statement) {
            Connection conn = null;
            try {
                conn = statement.getConnection();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                statement.close();
            }
            catch (Throwable e) {
                log.warn("Error closing statement : {} ", e.getMessage(), e);
            }
            finally {
                JDBC.closeConnection(conn);
            }
        }
    }

    public static void closeResultSetOnly(ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (Throwable e) {
                log.warn("Error closing result set : {} ", e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeResultSetAndConnection(ResultSet rs) {
        if (null != rs) {
            Connection conn = null;
            Statement stmt = null;
            try {
                stmt = rs.getStatement();
                conn = stmt.getConnection();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                rs.close();
            }
            catch (Throwable e) {
                log.warn("Error closing result set : {} ", e.getMessage(), e);
            }
            finally {
                JDBC.closeStatementOnly(stmt);
                JDBC.closeConnection(conn);
            }
        }
    }

    public static void closeResultSetAndStatement(ResultSet rs) {
        Statement stmt = null;
        if (null != rs) {
            try {
                stmt = rs.getStatement();
            }
            catch (Throwable e) {
                log.error(e);
            }
            try {
                rs.close();
            }
            catch (Throwable e) {
                log.warn("Error closing result set : {} ", e.getMessage(), e);
            }
            finally {
                JDBC.closeStatementOnly(stmt);
            }
        }
    }

    public static String tryExtractServerString(String url) {
        String[] parts;
        if (!Strings.startsWith(url, "jdbc:", true)) {
            return null;
        }
        int index = (url = Urls.removeQueryString(url)).indexOf(58, 5);
        if (index < 0) {
            return null;
        }
        if ((index = (url = url.substring(index + 1)).indexOf(59)) > 0) {
            url = url.substring(0, index);
        }
        if ((index = url.indexOf("//")) >= 0) {
            url = url.substring(index + 2);
        } else {
            index = url.indexOf(64);
            if (index >= 0) {
                url = url.substring(index + 1);
            }
        }
        index = url.indexOf(47);
        if (index > 0) {
            url = url.substring(0, index);
        }
        if ((parts = Strings.split(url, ':')).length >= 2) {
            return parts[0] + ":" + parts[1];
        }
        if (url.length() <= 5) {
            return null;
        }
        return url;
    }

    protected JDBC() {
    }
}

