/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.jdbc;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import leap.lang.Args;
import leap.lang.exception.ObjectNotFoundException;
import leap.lang.jdbc.JdbcType;
import leap.lang.jdbc.JdbcTypeKind;

public class JdbcTypes {
    private static final Map<Integer, JdbcType> typeCodeToJdbcTypeMappings = new HashMap<Integer, JdbcType>();
    private static final Map<String, JdbcType> typeNameToJdbcTypeMappings = new HashMap<String, JdbcType>();
    public static final int UNKNOW_TYPE_CODE = Integer.MIN_VALUE;
    public static final String ARRAY_TYPE_NAME = "array";
    public static final String BIGINT_TYPE_NAME = "bigint";
    public static final String BINARY_TYPE_NAME = "binary";
    public static final String BIT_TYPE_NAME = "bit";
    public static final String BLOB_TYPE_NAME = "blob";
    public static final String BOOLEAN_TYPE_NAME = "boolean";
    public static final String CHAR_TYPE_NAME = "char";
    public static final String CLOB_TYPE_NAME = "clob";
    public static final String DATALINK_TYPE_NAME = "datalink";
    public static final String DATE_TYPE_NAME = "date";
    public static final String DECIMAL_TYPE_NAME = "decimal";
    public static final String DISTINCT_TYPE_NAME = "distinct";
    public static final String DOUBLE_TYPE_NAME = "double";
    public static final String FLOAT_TYPE_NAME = "float";
    public static final String INTEGER_TYPE_NAME = "integer";
    public static final String JAVA_OBJECT_TYPE_NAME = "java_object";
    public static final String LONGVARBINARY_TYPE_NAME = "longvarbinary";
    public static final String LONGVARCHAR_TYPE_NAME = "longvarchar";
    public static final String NULL_TYPE_NAME = "null";
    public static final String OTHER_TYPE_NAME = "other";
    public static final String NUMERIC_TYPE_NAME = "numeric";
    public static final String REAL_TYPE_NAME = "real";
    public static final String REF_TYPE_NAME = "ref";
    public static final String SMALLINT_TYPE_NAME = "smallint";
    public static final String STRUCT_TYPE_NAME = "struct";
    public static final String TIME_TYPE_NAME = "time";
    public static final String TIMESTAMP_TYPE_NAME = "timestamp";
    public static final String TINYINT_TYPE_NAME = "tinyint";
    public static final String VARBINARY_TYPE_NAME = "varbinary";
    public static final String VARCHAR_TYPE_NAME = "varchar";
    public static final String ROWID_TYPE_NAME = "rowid";
    public static final String NCHAR_TYPE_NAME = "nchar";
    public static final String NVARCHAR_TYPE_NAME = "nvarchar";
    public static final String LONGNVARCHAR_TYPE_NAME = "longnvarchar";
    public static final String NCLOB_TYPE_NAME = "nclob";
    public static final String SQLXML_TYPE_NAME = "sqlxml";

    private static void register(int typeCode, String typeName, JdbcTypeKind kind, Class<?> defaultJavaType, boolean supportsLength, boolean supportsPrecisionAndScale) {
        JdbcTypes.register(typeCode, typeName, kind, defaultJavaType, defaultJavaType, supportsLength, supportsPrecisionAndScale);
    }

    private static void register(int typeCode, String typeName, JdbcTypeKind kind, Class<?> defaultReadType, Class<?> defaultSaveType, boolean supportsLength, boolean supportsPrecisionAndScale) {
        JdbcType type = new JdbcType(typeCode, typeName, kind, defaultReadType, defaultSaveType, supportsLength, supportsPrecisionAndScale);
        typeCodeToJdbcTypeMappings.put(typeCode, type);
        typeNameToJdbcTypeMappings.put(typeName, type);
    }

    public static Iterable<JdbcType> all() {
        return typeCodeToJdbcTypeMappings.values();
    }

    public static JdbcType forTypeCode(int typeCode) throws ObjectNotFoundException {
        JdbcType type = typeCodeToJdbcTypeMappings.get(typeCode);
        if (null == type) {
            throw new ObjectNotFoundException("no jdbc type found for code '" + typeCode + "'");
        }
        return type;
    }

    public static JdbcType tryForTypeCode(int typeCode) {
        return typeCodeToJdbcTypeMappings.get(typeCode);
    }

    public static JdbcType forTypeName(String typeName) throws IllegalArgumentException, ObjectNotFoundException {
        Args.notEmpty(typeName, "type name");
        JdbcType type = typeNameToJdbcTypeMappings.get(typeName.toLowerCase());
        if (null == type) {
            throw new ObjectNotFoundException("no jdbc type found for name '" + typeName + "'");
        }
        return type;
    }

    public static JdbcType tryForTypeName(String typeName) {
        return null == typeName ? null : typeNameToJdbcTypeMappings.get(typeName.toLowerCase());
    }

    protected JdbcTypes() {
    }

    static {
        JdbcTypes.register(-5, BIGINT_TYPE_NAME, JdbcTypeKind.Numeric, Long.TYPE, false, false);
        JdbcTypes.register(-7, BIT_TYPE_NAME, JdbcTypeKind.Numeric, Boolean.TYPE, Short.TYPE, false, false);
        JdbcTypes.register(16, BOOLEAN_TYPE_NAME, JdbcTypeKind.Numeric, Boolean.TYPE, false, false);
        JdbcTypes.register(3, DECIMAL_TYPE_NAME, JdbcTypeKind.Numeric, BigDecimal.class, false, true);
        JdbcTypes.register(8, DOUBLE_TYPE_NAME, JdbcTypeKind.Numeric, Double.TYPE, Double.class, false, false);
        JdbcTypes.register(6, FLOAT_TYPE_NAME, JdbcTypeKind.Numeric, Double.TYPE, Double.class, false, false);
        JdbcTypes.register(4, INTEGER_TYPE_NAME, JdbcTypeKind.Numeric, Integer.TYPE, Integer.class, false, false);
        JdbcTypes.register(2, NUMERIC_TYPE_NAME, JdbcTypeKind.Numeric, BigDecimal.class, false, true);
        JdbcTypes.register(7, REAL_TYPE_NAME, JdbcTypeKind.Numeric, Float.TYPE, Float.class, false, false);
        JdbcTypes.register(5, SMALLINT_TYPE_NAME, JdbcTypeKind.Numeric, Short.TYPE, Short.class, false, false);
        JdbcTypes.register(-6, TINYINT_TYPE_NAME, JdbcTypeKind.Numeric, Short.TYPE, Short.class, false, false);
        JdbcTypes.register(1, CHAR_TYPE_NAME, JdbcTypeKind.Text, String.class, true, false);
        JdbcTypes.register(2005, CLOB_TYPE_NAME, JdbcTypeKind.Text, String.class, Clob.class, false, false);
        JdbcTypes.register(-1, LONGVARCHAR_TYPE_NAME, JdbcTypeKind.Text, String.class, true, false);
        JdbcTypes.register(12, VARCHAR_TYPE_NAME, JdbcTypeKind.Text, String.class, true, false);
        JdbcTypes.register(-15, NCHAR_TYPE_NAME, JdbcTypeKind.Text, String.class, true, false);
        JdbcTypes.register(-9, NVARCHAR_TYPE_NAME, JdbcTypeKind.Text, String.class, true, false);
        JdbcTypes.register(-16, LONGNVARCHAR_TYPE_NAME, JdbcTypeKind.Text, String.class, true, false);
        JdbcTypes.register(2011, NCLOB_TYPE_NAME, JdbcTypeKind.Text, String.class, Clob.class, false, false);
        JdbcTypes.register(2009, SQLXML_TYPE_NAME, JdbcTypeKind.Text, String.class, false, false);
        JdbcTypes.register(91, DATE_TYPE_NAME, JdbcTypeKind.Temporal, Date.class, false, false);
        JdbcTypes.register(92, TIME_TYPE_NAME, JdbcTypeKind.Temporal, Time.class, false, false);
        JdbcTypes.register(93, TIMESTAMP_TYPE_NAME, JdbcTypeKind.Temporal, Timestamp.class, false, false);
        JdbcTypes.register(-2, BINARY_TYPE_NAME, JdbcTypeKind.Binary, byte[].class, true, false);
        JdbcTypes.register(2004, BLOB_TYPE_NAME, JdbcTypeKind.Binary, byte[].class, Blob.class, false, false);
        JdbcTypes.register(-4, LONGVARBINARY_TYPE_NAME, JdbcTypeKind.Binary, byte[].class, true, false);
        JdbcTypes.register(-3, VARBINARY_TYPE_NAME, JdbcTypeKind.Binary, byte[].class, true, false);
        JdbcTypes.register(2003, ARRAY_TYPE_NAME, JdbcTypeKind.Special, Array.class, false, false);
        JdbcTypes.register(70, DATALINK_TYPE_NAME, JdbcTypeKind.Special, null, false, false);
        JdbcTypes.register(2001, DISTINCT_TYPE_NAME, JdbcTypeKind.Special, null, false, false);
        JdbcTypes.register(2000, JAVA_OBJECT_TYPE_NAME, JdbcTypeKind.Special, null, false, false);
        JdbcTypes.register(0, NULL_TYPE_NAME, JdbcTypeKind.Special, null, false, false);
        JdbcTypes.register(1111, OTHER_TYPE_NAME, JdbcTypeKind.Special, null, false, false);
        JdbcTypes.register(2006, REF_TYPE_NAME, JdbcTypeKind.Special, Ref.class, false, false);
        JdbcTypes.register(2002, STRUCT_TYPE_NAME, JdbcTypeKind.Special, Struct.class, false, false);
    }
}

