/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import leap.lang.exception.NestedIOException;
import leap.lang.io.IO;

public class SimpleBlob
implements Blob {
    private InputStream stream;
    private long length;
    private boolean needsReset = false;
    private byte[] bytes;

    public SimpleBlob(byte[] bytes) {
        this.bytes = bytes;
        this.stream = new ByteArrayInputStream(bytes);
        this.length = bytes.length;
    }

    public SimpleBlob(InputStream stream, long length) {
        this.stream = stream;
        this.length = length;
    }

    @Override
    public long length() throws SQLException {
        return this.length;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (null == this.bytes) {
            try {
                this.bytes = IO.readByteArray(this.stream);
            }
            catch (NestedIOException e) {
                throw new SQLException("Could not get bytes from stream");
            }
        }
        byte[] data = new byte[length];
        System.arraycopy(this.bytes, (int)pos - 1, data, 0, length);
        return data;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        try {
            if (this.needsReset) {
                this.stream.reset();
                this.bytes = null;
            }
        }
        catch (IOException ioe) {
            throw new SQLException("Could not reset reader");
        }
        this.needsReset = true;
        return this.stream;
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        SimpleBlob.unsupported();
        return 0L;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        SimpleBlob.unsupported();
        return 0L;
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        SimpleBlob.unsupported();
        return 0;
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        SimpleBlob.unsupported();
        return 0;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        SimpleBlob.unsupported();
        return null;
    }

    @Override
    public void truncate(long len) throws SQLException {
        SimpleBlob.unsupported();
    }

    @Override
    public void free() throws SQLException {
        this.bytes = null;
        IO.close(this.stream);
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        SimpleBlob.unsupported();
        return null;
    }

    private static void unsupported() {
        throw new UnsupportedOperationException("Operation not supported in this blob");
    }
}

