/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import leap.lang.convert.StringConvertibleTo;
import leap.lang.io.IO;
import leap.lang.io.ReaderInputStream;

public class SimpleClob
implements Clob,
StringConvertibleTo {
    private String string;
    private Reader reader;
    private long length;
    private boolean needsReset = false;

    public SimpleClob(String string) {
        this.string = string;
        this.reader = new StringReader(string);
        this.length = string.length();
    }

    public SimpleClob(Reader reader, long length) {
        this.reader = reader;
        this.length = length;
    }

    @Override
    public long length() throws SQLException {
        return this.length;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.resetIfNeeded();
        return new ReaderInputStream(this.reader);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.resetIfNeeded();
        return this.reader;
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (this.string == null) {
            throw new UnsupportedOperationException("Clob was not created from string; cannot substring");
        }
        int startIndex = (int)(pos - 1L);
        int endIndex = Math.min(startIndex + length, this.string.length());
        return this.string.substring(startIndex, endIndex);
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        SimpleClob.unsupported();
        return 0L;
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        SimpleClob.unsupported();
        return 0L;
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        SimpleClob.unsupported();
        return 0;
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        SimpleClob.unsupported();
        return 0;
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        SimpleClob.unsupported();
        return null;
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        SimpleClob.unsupported();
        return null;
    }

    @Override
    public void truncate(long len) throws SQLException {
        SimpleClob.unsupported();
    }

    protected void resetIfNeeded() throws SQLException {
        try {
            if (this.needsReset) {
                this.reader.reset();
            }
        }
        catch (IOException ioe) {
            throw new SQLException("could not reset reader", ioe);
        }
        this.needsReset = true;
    }

    @Override
    public void free() throws SQLException {
        this.string = null;
        IO.close(this.reader);
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        SimpleClob.unsupported();
        return null;
    }

    private static void unsupported() {
        throw new UnsupportedOperationException("operation not supported in this clob");
    }

    @Override
    public String convertToString() {
        return this.string;
    }
}

