/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import leap.lang.jdbc.ConnectionProxy;
import leap.lang.jdbc.ResultSetProxy;
import leap.lang.jdbc.StatementWrapper;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;

public class StatementProxy<T extends ConnectionProxy>
extends StatementWrapper {
    private static final Log log = LogFactory.get(StatementProxy.class);
    protected final T conn;
    protected final Exception stackTraceException;
    protected long lastExecutingTime;
    protected long lastExecutingDurationMs;
    protected String lastExecutingSql;
    protected boolean closed;

    public StatementProxy(T connection, Statement stmt) {
        this(connection, stmt, false);
    }

    public StatementProxy(T connection, Statement stmt, boolean stackTrace) {
        super(stmt);
        this.conn = connection;
        this.stackTraceException = stackTrace ? new Exception("") : null;
    }

    public final Statement wrapped() {
        return this.stmt;
    }

    public final String getLastExecutingSql() {
        return this.lastExecutingSql;
    }

    public final long getLastExecutingTime() {
        return this.lastExecutingTime;
    }

    public final long getLastExecutingDurationMs() {
        return this.lastExecutingDurationMs;
    }

    public StackTraceElement[] getStackTraceOnOpen() {
        return ((ConnectionProxy)this.conn).getStackTrace(this.stackTraceException);
    }

    @Override
    public final Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public final ResultSet getResultSet() throws SQLException {
        return this.proxyOfResultSet(super.getResultSet());
    }

    @Override
    public final ResultSet getGeneratedKeys() throws SQLException {
        return this.proxyOfResultSet(super.getGeneratedKeys());
    }

    @Override
    public final ResultSet executeQuery(String sql) throws SQLException {
        try {
            this.beginExecute(sql);
            ResultSet resultSet = this.proxyOfResultSet(this.stmt.executeQuery(sql));
            return resultSet;
        }
        catch (SQLException e) {
            throw this.handleSQLException(e);
        }
        finally {
            this.endExecute();
        }
    }

    @Override
    public final int executeUpdate(String sql) throws SQLException {
        try {
            this.beginExecute(sql);
            int n = this.stmt.executeUpdate(sql);
            return n;
        }
        catch (SQLException e) {
            throw this.handleSQLException(e);
        }
        finally {
            this.endExecute();
        }
    }

    @Override
    public final boolean execute(String sql) throws SQLException {
        try {
            this.beginExecute(sql);
            boolean bl = this.stmt.execute(sql);
            return bl;
        }
        catch (SQLException e) {
            throw this.handleSQLException(e);
        }
        finally {
            this.endExecute();
        }
    }

    @Override
    public final void addBatch(String sql) throws SQLException {
        this.lastExecutingSql = sql;
        try {
            super.addBatch(sql);
        }
        catch (SQLException e) {
            throw this.handleSQLException(e);
        }
    }

    @Override
    public final int[] executeBatch() throws SQLException {
        try {
            this.beginExecute(null);
            int[] nArray = this.stmt.executeBatch();
            return nArray;
        }
        catch (SQLException e) {
            throw this.handleSQLException(e);
        }
        finally {
            this.endExecute();
        }
    }

    @Override
    public final int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this.beginExecute(sql);
            int n = this.stmt.executeUpdate(sql, autoGeneratedKeys);
            return n;
        }
        catch (SQLException e) {
            throw this.handleSQLException(e);
        }
        finally {
            this.endExecute();
        }
    }

    @Override
    public final int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            this.beginExecute(sql);
            int n = this.stmt.executeUpdate(sql, columnIndexes);
            return n;
        }
        catch (SQLException e) {
            throw this.handleSQLException(e);
        }
        finally {
            this.endExecute();
        }
    }

    @Override
    public final int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            this.beginExecute(sql);
            int n = this.stmt.executeUpdate(sql, columnNames);
            return n;
        }
        catch (SQLException e) {
            throw this.handleSQLException(e);
        }
        finally {
            this.endExecute();
        }
    }

    @Override
    public final boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this.beginExecute(sql);
            boolean bl = this.stmt.execute(sql, autoGeneratedKeys);
            return bl;
        }
        catch (SQLException e) {
            throw this.handleSQLException(e);
        }
        finally {
            this.endExecute();
        }
    }

    @Override
    public final boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            this.beginExecute(sql);
            boolean bl = this.stmt.execute(sql, columnIndexes);
            return bl;
        }
        catch (SQLException e) {
            throw this.handleSQLException(e);
        }
        finally {
            this.endExecute();
        }
    }

    @Override
    public final boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            this.beginExecute(sql);
            boolean bl = this.stmt.execute(sql, columnNames);
            return bl;
        }
        catch (SQLException e) {
            throw this.handleSQLException(e);
        }
        finally {
            this.endExecute();
        }
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public final void close() throws SQLException {
        if (this.closed) {
            log.warn("Invalid state, the proxy statement already closed", new Exception("Statement already closed"));
            return;
        }
        this.closed = true;
        ((ConnectionProxy)this.conn).closeStatement(this);
    }

    protected void beginExecute(String sql) {
        this.lastExecutingTime = System.currentTimeMillis();
        this.lastExecutingDurationMs = -1L;
        if (null != sql) {
            this.lastExecutingSql = sql;
        }
    }

    protected void endExecute() {
        this.lastExecutingDurationMs = System.currentTimeMillis() - this.lastExecutingTime;
        this.lastExecutingTime = -1L;
        ((ConnectionProxy)this.conn).endExecuteStatement(this);
    }

    protected SQLException handleSQLException(SQLException e) {
        return e;
    }

    protected ResultSet proxyOfResultSet(ResultSet rs) {
        return new ResultSetProxy(this, rs);
    }
}

