/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.jmx;

import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import leap.lang.exception.ObjectNotFoundException;
import leap.lang.jmx.MAttribute;
import leap.lang.jmx.MConverts;
import leap.lang.jmx.MOperation;
import leap.lang.jmx.MSignature;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.lang.reflect.ReflectException;

public class MBean
implements DynamicMBean {
    private static final Log log = LogFactory.get(MBean.class);
    protected final Object bean;
    protected final MBeanInfo mbeanInfo;
    protected final Map<String, MAttribute> attributes;
    protected final Map<MSignature, MOperation> operations;

    public MBean(Object bean, MBeanInfo mbeanInfo, Map<String, MAttribute> attributes, Map<MSignature, MOperation> operations) {
        this.bean = bean;
        this.mbeanInfo = mbeanInfo;
        this.attributes = attributes;
        this.operations = operations;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        if (null != attributes) {
            for (String name : attributes) {
                try {
                    list.add(new Attribute(name, this.getAttribute(name)));
                }
                catch (Exception e) {
                    log.error("Error get attribute '" + name + "' : " + e.getMessage(), e);
                }
            }
        }
        return list;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList list = new AttributeList();
        if (null != attributes) {
            for (Attribute a : attributes.asList()) {
                try {
                    this.setAttribute(a);
                    list.add(a);
                }
                catch (Exception e) {
                    log.error("Error set attribute '" + a.getName() + "' : " + e.getMessage(), e);
                }
            }
        }
        return list;
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        MAttribute a = this.attributes.get(name);
        if (null == a) {
            throw new AttributeNotFoundException("Attribute '" + name + "' not found in '" + this.bean.getClass() + "'");
        }
        try {
            Object value = a.valued().getValue(this.bean);
            if (a.isOpen()) {
                value = MConverts.convert(value, a.getOpenType());
            }
            return value;
        }
        catch (ReflectException e) {
            throw new ReflectionException(e);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String name = attribute.getName();
        MAttribute a = this.attributes.get(name);
        if (null == a) {
            throw new AttributeNotFoundException("Attribute '" + name + "' not found in '" + this.bean.getClass() + "'");
        }
        try {
            a.valued().setValue(this.bean, attribute.getValue());
        }
        catch (ReflectException e) {
            throw new ReflectionException(e);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        MOperation o = this.operations.get(new MSignature(actionName, signature));
        if (null == o) {
            throw new MBeanException(new ObjectNotFoundException("Operation '" + actionName + "' not found in '" + this.bean.getClass() + "'"));
        }
        try {
            Object value = o.getMethod().invoke(this.bean, params);
            if (o.isOpen()) {
                value = MConverts.convert(value, o.getReturnOpenType());
            }
            return value;
        }
        catch (ReflectException e) {
            throw new ReflectionException(e);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }
}

