/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.jmx;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import leap.lang.Buildable;
import leap.lang.Named;
import leap.lang.Strings;
import leap.lang.beans.BeanProperty;
import leap.lang.beans.BeanType;
import leap.lang.jmx.MAttribute;
import leap.lang.jmx.MBean;
import leap.lang.jmx.MBeanTypes;
import leap.lang.jmx.MOperation;
import leap.lang.jmx.MSignature;
import leap.lang.jmx.Managed;
import leap.lang.reflect.ReflectMethod;
import leap.lang.reflect.ReflectParameter;

public class MBeanBuilder
implements Buildable<MBean> {
    private static final MBeanConstructorInfo[] EMPTY_CONSTRUCTORS = new ModelMBeanConstructorInfo[0];
    private static final MBeanNotificationInfo[] EMPTY_NOTIFICATIONS = new ModelMBeanNotificationInfo[0];
    protected final Object bean;
    protected final Map<String, MAttribute> attributes = new LinkedHashMap<String, MAttribute>();
    protected final Map<MSignature, MOperation> operations = new LinkedHashMap<MSignature, MOperation>();
    protected final List<MBeanAttributeInfo> attributeInfos = new ArrayList<MBeanAttributeInfo>();
    protected final List<MBeanOperationInfo> operationInfos = new ArrayList<MBeanOperationInfo>();
    protected String className;
    protected String description;

    public MBeanBuilder(Object bean) {
        this.bean = bean;
        this.initFromBean();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    protected void initFromBean() {
        String desc;
        String name;
        this.className = this.bean.getClass().getName();
        Managed a = this.bean.getClass().getAnnotation(Managed.class);
        if (null != a) {
            this.description = a.desc();
        }
        BeanType bt = BeanType.of(this.bean.getClass());
        for (BeanProperty beanProperty : bt.getProperties()) {
            a = beanProperty.getAnnotation(Managed.class);
            if (null == a) continue;
            name = Strings.firstNotEmpty(a.name(), beanProperty.getName());
            desc = Strings.firstNotEmpty(a.desc(), beanProperty.getName());
            boolean readable = false;
            boolean writable = false;
            if (beanProperty.isField() && beanProperty.getReflectField().isAnnotationPresent(Managed.class)) {
                readable = beanProperty.isReadable();
                writable = beanProperty.isWritable();
            } else {
                if (beanProperty.hasGetter() && beanProperty.getGetter().isAnnotationPresent(Managed.class)) {
                    readable = true;
                }
                if (beanProperty.hasSetter() && beanProperty.getSetter().isAnnotationPresent(Managed.class)) {
                    writable = true;
                }
            }
            OpenType type = MBeanTypes.of(beanProperty.getTypeInfo());
            OpenMBeanAttributeInfoSupport ai = new OpenMBeanAttributeInfoSupport(name, desc, type, readable, writable, false);
            this.attributeInfos.add(ai);
            this.attributes.put(name, new MAttribute(ai, beanProperty));
        }
        for (Named named : bt.getReflectClass().getMethods()) {
            if (((ReflectMethod)named).isGetterMethod() || ((ReflectMethod)named).isSetterMethod() || ((ReflectMethod)named).isSynthetic() || !((ReflectMethod)named).isPublic() || null == (a = ((ReflectMethod)named).getAnnotation(Managed.class))) continue;
            name = Strings.firstNotEmpty(a.name(), ((ReflectMethod)named).getName());
            desc = Strings.firstNotEmpty(a.desc(), ((ReflectMethod)named).getName());
            OpenMBeanParameterInfo[] parameterInfos = MBeanBuilder.params((ReflectMethod)named);
            OpenType returnType = MBeanTypes.of(((ReflectMethod)named).getReturnType(), null);
            OpenMBeanOperationInfoSupport oi = new OpenMBeanOperationInfoSupport(name, desc, parameterInfos, returnType, 3);
            this.operationInfos.add(oi);
            this.operations.put(new MSignature(name, ((ReflectMethod)named).getReflectedMethod()), new MOperation(oi, (ReflectMethod)named));
        }
    }

    private static OpenMBeanParameterInfo[] params(ReflectMethod rm) {
        OpenMBeanParameterInfo[] params = new OpenMBeanParameterInfo[rm.getParameters().length];
        for (int i = 0; i < params.length; ++i) {
            ReflectParameter p = rm.getParameters()[i];
            params[i] = new OpenMBeanParameterInfoSupport(p.getName(), p.getName(), MBeanTypes.of(p.getType(), p.getGenericType()));
        }
        return params;
    }

    @Override
    public MBean build() {
        MBeanAttributeInfo[] attributeInfoArray = this.attributeInfos.toArray(new MBeanAttributeInfo[0]);
        MBeanOperationInfo[] operationInfoArray = this.operationInfos.toArray(new MBeanOperationInfo[0]);
        MBeanInfo mbeanInfo = new MBeanInfo(this.className, this.description, attributeInfoArray, EMPTY_CONSTRUCTORS, operationInfoArray, EMPTY_NOTIFICATIONS);
        return new MBean(this.bean, mbeanInfo, this.attributes, this.operations);
    }
}

