/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.jmx;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import leap.lang.Primitives;
import leap.lang.TypeInfo;
import leap.lang.Types;
import leap.lang.beans.BeanProperty;
import leap.lang.beans.BeanType;
import leap.lang.jmx.MException;

class MBeanTypes {
    private static final Map<String, SimpleType> SIMPLE_TYPES = new HashMap<String, SimpleType>();

    public static OpenType of(Class<?> type, Type genericType) {
        if (type == Void.class || type == Void.TYPE) {
            return SimpleType.VOID;
        }
        TypeInfo ti = Types.getTypeInfo(type, genericType);
        return MBeanTypes.of(ti);
    }

    public static OpenType of(TypeInfo ti) {
        if (ti.getType() == Void.class || ti.getType() == Void.TYPE) {
            return SimpleType.VOID;
        }
        if (ti.isSimpleType()) {
            return MBeanTypes.forSimpleType(ti.getType());
        }
        if (ti.isCollectionType()) {
            try {
                return new ArrayType(1, MBeanTypes.of(ti.getElementTypeInfo()));
            }
            catch (OpenDataException e) {
                throw new MException("Invalid array type", e);
            }
        }
        return MBeanTypes.forCompositeType(ti.getType());
    }

    public static SimpleType forSimpleType(Class<?> cls) {
        if (cls.isPrimitive()) {
            cls = Primitives.wrap(cls);
        }
        if (!SIMPLE_TYPES.containsKey(cls.getName())) {
            throw new MException("Unsupported simple type '" + cls.getName() + "' in jmx");
        }
        return SIMPLE_TYPES.get(cls.getName());
    }

    public static CompositeType forCompositeType(Class<?> c) {
        BeanType bt = BeanType.of(c);
        ArrayList<String> itemNames = new ArrayList<String>();
        ArrayList<OpenType> itemTypes = new ArrayList<OpenType>();
        for (BeanProperty bp : bt.getProperties()) {
            if (!bp.isReadable()) continue;
            itemNames.add(bp.getName());
            itemTypes.add(MBeanTypes.of(bp.getType(), bp.getGenericType()));
        }
        String[] itemNamesArray = itemNames.toArray(new String[0]);
        try {
            return new CompositeType(c.getName(), c.getSimpleName(), itemNamesArray, itemNamesArray, itemTypes.toArray(new OpenType[0]));
        }
        catch (OpenDataException e) {
            throw new MException(e.getMessage(), e);
        }
    }

    protected MBeanTypes() {
    }

    static {
        SIMPLE_TYPES.put(SimpleType.BIGDECIMAL.getClassName(), SimpleType.BIGDECIMAL);
        SIMPLE_TYPES.put(SimpleType.BIGINTEGER.getClassName(), SimpleType.BIGINTEGER);
        SIMPLE_TYPES.put(SimpleType.BOOLEAN.getClassName(), SimpleType.BOOLEAN);
        SIMPLE_TYPES.put(SimpleType.BYTE.getClassName(), SimpleType.BYTE);
        SIMPLE_TYPES.put(SimpleType.CHARACTER.getClassName(), SimpleType.CHARACTER);
        SIMPLE_TYPES.put(SimpleType.DATE.getClassName(), SimpleType.DATE);
        SIMPLE_TYPES.put(SimpleType.DOUBLE.getClassName(), SimpleType.DOUBLE);
        SIMPLE_TYPES.put(SimpleType.FLOAT.getClassName(), SimpleType.FLOAT);
        SIMPLE_TYPES.put(SimpleType.INTEGER.getClassName(), SimpleType.INTEGER);
        SIMPLE_TYPES.put(SimpleType.LONG.getClassName(), SimpleType.LONG);
        SIMPLE_TYPES.put(SimpleType.SHORT.getClassName(), SimpleType.SHORT);
        SIMPLE_TYPES.put(SimpleType.STRING.getClassName(), SimpleType.STRING);
        SIMPLE_TYPES.put(SimpleType.VOID.getClassName(), SimpleType.VOID);
        SIMPLE_TYPES.put(SimpleType.OBJECTNAME.getClassName(), SimpleType.OBJECTNAME);
    }
}

