/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.jmx;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import leap.lang.Classes;
import leap.lang.Enumerables;
import leap.lang.beans.BeanType;
import leap.lang.jmx.MException;

public class MConverts {
    static Object convert(Object value, OpenType targetType) {
        if (null == value) {
            return null;
        }
        if (targetType instanceof SimpleType) {
            return value;
        }
        if (targetType instanceof CompositeType) {
            CompositeType ct = (CompositeType)targetType;
            try {
                return MConverts.convertToCompositeData(value, ct);
            }
            catch (OpenDataException e) {
                throw new MException(e);
            }
        }
        if (targetType instanceof ArrayType) {
            ArrayType at = (ArrayType)targetType;
            OpenType<?> elementType = at.getElementOpenType();
            if (elementType instanceof SimpleType) {
                return Enumerables.of(value).toList();
            }
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object item : Enumerables.of(value)) {
                list.add(MConverts.convert(item, elementType));
            }
            return list;
        }
        throw new IllegalStateException("Not supported open type '" + targetType + "'");
    }

    static CompositeData convertToCompositeData(Object bean, CompositeType ct) throws OpenDataException {
        BeanType bt = BeanType.of(bean.getClass());
        LinkedHashMap<String, Object[]> map = new LinkedHashMap<String, Object[]>();
        for (String name : ct.keySet()) {
            OpenType<?> type = ct.getType(name);
            Object value = bt.getProperty(name).getValue(bean);
            Object[] converted = MConverts.convert(value, type);
            if (type instanceof ArrayType) {
                List list = (List)converted;
                Class<?> elementType = Classes.forName(((ArrayType)type).getElementOpenType().getClassName());
                converted = list.toArray((Object[])Array.newInstance(elementType, list.size()));
            }
            map.put(name, converted);
        }
        return new CompositeDataSupport(ct, map);
    }

    protected MConverts() {
    }
}

