/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.jmx;

import java.lang.reflect.Method;
import java.util.ArrayList;
import leap.lang.Arrays2;

final class MSignature {
    private final String actionName;
    private final String[] parameterTypes;

    MSignature(String actionName, Method method) {
        this.actionName = actionName;
        ArrayList<String> types = new ArrayList<String>();
        for (Class<?> type : method.getParameterTypes()) {
            types.add(type.getName());
        }
        this.parameterTypes = types.toArray(new String[0]);
    }

    MSignature(String actionName, String[] parameterTypes) {
        this.actionName = actionName;
        this.parameterTypes = parameterTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MSignature s = (MSignature)o;
        if (!this.actionName.equals(s.actionName)) {
            return false;
        }
        return Arrays2.equals(this.parameterTypes, s.parameterTypes);
    }

    public int hashCode() {
        int result = 31 * this.actionName.hashCode();
        if (this.parameterTypes.length > 0) {
            for (String pt : this.parameterTypes) {
                result += pt.hashCode();
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.actionName).append('(');
        boolean first = true;
        for (String type : this.parameterTypes) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(type);
            first = false;
        }
        sb.append(')');
        return sb.toString();
    }
}

