/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.jmx;

import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import leap.lang.exception.ObjectExistsException;
import leap.lang.jmx.MBean;
import leap.lang.jmx.MBeanBuilder;
import leap.lang.jmx.MBeanExporter;
import leap.lang.jmx.MException;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;

public class SimpleMBeanExporter
implements MBeanExporter {
    public static final String DEFAULT_DOMAIN = "beans";
    private static final Log log = LogFactory.get(SimpleMBeanExporter.class);
    protected final MBeanServer server;
    protected final String domain;
    protected final Map<ObjectName, Object> exportedBeans = new ConcurrentHashMap<ObjectName, Object>();

    public SimpleMBeanExporter() {
        this(ManagementFactory.getPlatformMBeanServer(), DEFAULT_DOMAIN);
    }

    public SimpleMBeanExporter(MBeanServer server) {
        this(server, DEFAULT_DOMAIN);
    }

    public SimpleMBeanExporter(MBeanServer server, String domain) {
        this.server = server;
        this.domain = domain;
    }

    @Override
    public MBeanServer getServer() {
        return this.server;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName createObjectName(String name) {
        name = this.domain + ":name=" + name;
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new MException(e);
        }
    }

    @Override
    public void export(String name, Object bean) {
        this.export(this.createObjectName(name), bean);
    }

    @Override
    public void export(ObjectName name, Object bean) {
        if (this.exportedBeans.containsKey(name)) {
            throw new ObjectExistsException("Jmx bean '" + name + "' already exported!");
        }
        MBean mbean = new MBeanBuilder(bean).build();
        try {
            this.server.registerMBean(mbean, name);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException e) {
            throw new MException(e.getMessage(), e);
        }
        catch (NotCompliantMBeanException e) {
            throw new IllegalStateException(e);
        }
        this.exportedBeans.put(name, Boolean.TRUE);
    }

    @Override
    public void unexportAll() {
        for (ObjectName name : this.exportedBeans.keySet()) {
            this.unexport(name);
        }
    }

    @Override
    public boolean unexport(ObjectName name) {
        try {
            this.server.unregisterMBean(name);
            return true;
        }
        catch (Exception e) {
            log.warn("Error unexport mbean '" + name + "'", e);
            return false;
        }
    }
}

