/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.js;

import java.io.IOException;
import leap.lang.Exceptions;

public class JS {
    public static String escape(CharSequence input) {
        if (input == null) {
            return null;
        }
        StringBuilder filtered = new StringBuilder(input.length());
        try {
            JS.escapeAndAppend(input, (Appendable)filtered);
        }
        catch (IOException e) {
            throw Exceptions.wrap(e);
        }
        return filtered.toString();
    }

    public static void escapeAndAppend(CharSequence input, Appendable out) throws IOException {
        if (input == null) {
            return;
        }
        char prevChar = '\u0000';
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            JS.escape(prevChar, c, out);
            prevChar = c;
        }
    }

    public static void escapeAndAppend(char c, Appendable out) throws IOException {
        JS.escape('\u0000', c, out);
    }

    private static void escape(char prevChar, char c, Appendable out) throws IOException {
        if (c == '\"') {
            out.append("\\\"");
        } else if (c == '\'') {
            out.append("\\'");
        } else if (c == '\\') {
            out.append("\\\\");
        } else if (c == '/') {
            out.append("\\/");
        } else if (c == '\t') {
            out.append("\\t");
        } else if (c == '\n') {
            if (prevChar != '\r') {
                out.append("\\n");
            }
        } else if (c == '\r') {
            out.append("\\n");
        } else if (c == '\f') {
            out.append("\\f");
        } else if (c == '\b') {
            out.append("\\b");
        } else if (c == '\u000b') {
            out.append("\\v");
        } else if (c == '<') {
            out.append("\\u003C");
        } else if (c == '>') {
            out.append("\\u003E");
        } else if (c == '\u2028') {
            out.append("\\u2028");
        } else if (c == '\u2029') {
            out.append("\\u2029");
        } else {
            out.append(c);
        }
    }

    public static boolean isValidJavascriptFunction(String f) {
        for (int i = 0; i < f.length(); ++i) {
            if (Character.isJavaIdentifierPart(f.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected JS() {
    }
}

