/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.json;

import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import leap.lang.New;
import leap.lang.convert.ConvertContext;
import leap.lang.convert.Converts;
import leap.lang.json.JsonConcreteTypes;
import leap.lang.json.JsonDecoder;
import leap.lang.json.JsonSettings;
import leap.lang.json.JsonValue;
import leap.lang.json.JsonWriter;
import leap.lang.json.JsonWriterCreator;
import leap.lang.json.JsonWriterCreatorImpl;

public class JSON {
    private static final JsonDecoder decoder = new JsonDecoder();
    private static final ConvertContext convertContext = new ConvertContext(){

        @Override
        public ConvertContext.ConcreteTypes getConcreteTypes() {
            return JsonConcreteTypes.INSTANCE;
        }
    };

    public static JsonWriterCreator writer() {
        return new JsonWriterCreatorImpl(new StringBuilder());
    }

    public static JsonWriterCreator writer(Appendable out) {
        return new JsonWriterCreatorImpl(out);
    }

    public static JsonWriter createWriter() {
        return JSON.createWriter(new StringBuilder());
    }

    public static JsonWriter createWriter(JsonSettings settings) {
        return (JsonWriter)JSON.writer().setSettings(settings).create();
    }

    public static JsonWriter createWriter(Appendable out) {
        return new JsonWriterCreatorImpl(out).create();
    }

    public static JsonWriter createWriter(Appendable out, JsonSettings settings) {
        return (JsonWriter)JSON.writer(out).setSettings(settings).create();
    }

    public static String stringify(Object value) {
        return JSON.createWriter().value(value).toString();
    }

    public static String stringify(Object value, JsonSettings settings) {
        return JSON.createWriter(settings).value(value).toString();
    }

    public static JsonValue parse(String json) {
        return JsonValue.of(JSON.decode(json));
    }

    public static JsonValue parse(Reader json) {
        return JsonValue.of(JSON.decode(json));
    }

    public static String encode(Object value) {
        return JSON.createWriter().value(value).toString();
    }

    public static String encode(Object value, JsonSettings settings) {
        return JSON.createWriter(settings).value(value).toString();
    }

    public static void encode(Object value, Appendable out) {
        JSON.createWriter(out).value(value);
    }

    public static void encode(Object value, JsonSettings settings, Appendable out) {
        JSON.createWriter(out, settings).value(value);
    }

    public static <T> T decode(String json) {
        return (T)decoder.decode(json);
    }

    public static <T> T decode(Reader json) {
        return (T)decoder.decode(json);
    }

    public static <T> T decode(String json, Class<? extends T> targetType) {
        return Converts.convert(decoder.decode(json), targetType, null, convertContext);
    }

    public static <T> T decode(String json, Class<? extends T> targetType, Type genericType) {
        return Converts.convert(decoder.decode(json), targetType, genericType, convertContext);
    }

    public static <T> Map<String, T> decodeMap(String json, Class<? extends T> valueType) {
        Map<String, Object> map = JSON.decodeMap(json);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            entry.setValue(Converts.convert(entry.getValue(), valueType, null, convertContext));
        }
        return map;
    }

    public static <T> List<T> decodeList(String json, Class<? extends T> valueType) {
        T[] obj = JSON.decodeArray(json, valueType);
        return New.arrayList(obj);
    }

    public static <T> T decode(Reader json, Class<? extends T> targetType) {
        return Converts.convert(decoder.decode(json), targetType, null, convertContext);
    }

    public static <T> T decode(Reader json, Class<? extends T> targetType, Type genericType) {
        return Converts.convert(decoder.decode(json), targetType, genericType, convertContext);
    }

    public static Map<String, Object> decodeMap(String json) {
        return JSON.parse(json).asMap();
    }

    public static Object[] decodeArray(String json) {
        return JSON.parse(json).asArray();
    }

    public static Object[] decodeArray(Reader json) {
        return JSON.parse(json).asArray();
    }

    public static <T> T[] decodeArray(String json, Class<T> componentType) {
        Object[] a = (Object[])Array.newInstance(componentType, 0);
        return (Object[])Converts.convert(JSON.parse(json).asArray(), a.getClass(), null, convertContext);
    }

    public static <T> T[] decodeArray(Reader json, Class<T> componentType) {
        Object[] a = (Object[])Array.newInstance(componentType, 0);
        return (Object[])Converts.convert(JSON.parse(json).asArray(), a.getClass(), null, convertContext);
    }
}

