/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.json;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import leap.lang.Emptiable;
import leap.lang.collection.UnmodifiableIteratorBase;
import leap.lang.convert.Converts;
import leap.lang.json.JsonObject;
import leap.lang.json.JsonParsable;
import leap.lang.json.JsonValue;
import leap.lang.reflect.ReflectClass;

public class JsonArray
implements Iterable<JsonValue>,
Emptiable,
JsonValue {
    private final List list;

    public JsonArray(List list) {
        this.list = list;
    }

    @Override
    public Object raw() {
        return this.list;
    }

    @Override
    public <T> List<T> asList() {
        return this.list;
    }

    @Override
    public JsonArray asJsonArray() {
        return this;
    }

    public int length() {
        return this.list.size();
    }

    public <T> T get(int i) {
        return (T)this.list.get(i);
    }

    public <T> T get(int i, Class<T> type) {
        return Converts.convert(this.get(i), type);
    }

    public JsonValue getValue(int i) {
        Object o = this.get(i);
        return null == o ? null : JsonValue.of(o);
    }

    public JsonArray getArray(int i) {
        List list = (List)this.get(i);
        return null == list ? null : new JsonArray(list);
    }

    public JsonObject getObject(int i) {
        Map map = (Map)this.get(i);
        return null == map ? null : new JsonObject(map);
    }

    public String getString(int i) {
        return (String)this.get(i);
    }

    public Integer getInteger(int i) {
        return (Integer)this.get(i);
    }

    public Long getLong(int i) {
        return (Long)this.get(i);
    }

    public Boolean getBoolean(int i) {
        return (Boolean)this.get(i);
    }

    public Float getFloat(int i) {
        return (Float)this.get(i);
    }

    public Double getDouble(int i) {
        return (Double)this.get(i);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public String toString() {
        return this.list.toString();
    }

    public <T extends JsonParsable> List<T> parseList(Class<T> type) {
        ArrayList<JsonParsable> newList = new ArrayList<JsonParsable>();
        ReflectClass rc = ReflectClass.of(type);
        for (Object item : this.list) {
            JsonParsable obj = (JsonParsable)rc.newInstance();
            obj.parseJson(JsonValue.of(item));
            newList.add(obj);
        }
        return newList;
    }

    public <T extends JsonParsable> List<T> parseList(Supplier<T> factory) {
        ArrayList<JsonParsable> newList = new ArrayList<JsonParsable>();
        for (Object item : this.list) {
            JsonParsable obj = (JsonParsable)factory.get();
            obj.parseJson(JsonValue.of(item));
            newList.add(obj);
        }
        return newList;
    }

    @Override
    public Iterator<JsonValue> iterator() {
        final Iterator it = this.list.iterator();
        return new UnmodifiableIteratorBase<JsonValue>(){

            @Override
            protected JsonValue computeNext() {
                if (!it.hasNext()) {
                    return (JsonValue)this.endOfData();
                }
                return JsonValue.of(it.next());
            }
        };
    }
}

