/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.json;

import java.lang.reflect.Type;
import java.util.Map;
import leap.lang.Classes;
import leap.lang.Strings;
import leap.lang.convert.ConvertContext;
import leap.lang.json.JsonType;
import leap.lang.reflect.Reflection;

class JsonConcreteTypes
implements ConvertContext.ConcreteTypes {
    static final JsonConcreteTypes INSTANCE = new JsonConcreteTypes();

    JsonConcreteTypes() {
    }

    @Override
    public Object newInstance(ConvertContext context, Class<?> type, Type genericType, Map<String, Object> map) {
        JsonType jsonType = type.getAnnotation(JsonType.class);
        if (null == jsonType) {
            return null;
        }
        String propertyName = Strings.firstNotEmpty(jsonType.property(), jsonType.meta().getDefaultPropertyName());
        Object propertyValue = map.get(propertyName);
        if (null == propertyValue) {
            return null;
        }
        String name = (String)propertyValue;
        if (jsonType.meta() == JsonType.MetaType.CLASS_NAME) {
            return Reflection.newInstance(Classes.forName(name));
        }
        for (JsonType.SubType subType : jsonType.types()) {
            if (!subType.name().equals(name)) continue;
            return Reflection.newInstance(subType.type());
        }
        return null;
    }
}

