/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.json;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import leap.lang.Strings;
import leap.lang.convert.Converts;
import leap.lang.json.JsonArray;
import leap.lang.json.JsonValue;

public class JsonObject
implements JsonValue {
    private final Map<String, Object> map;

    public static JsonObject of(Map<String, Object> map) {
        return new JsonObject(map);
    }

    public JsonObject(Map map) {
        this.map = map;
    }

    @Override
    public Object raw() {
        return this.map;
    }

    @Override
    public Map<String, Object> asMap() {
        return this.map;
    }

    @Override
    public JsonObject asJsonObject() {
        return this;
    }

    public Set<String> keys() {
        return this.map.keySet();
    }

    public Collection<Object> values() {
        return this.map.values();
    }

    public boolean hasProperties() {
        return this.map.isEmpty();
    }

    public boolean hasProperty(String key) {
        return this.map.containsKey(key);
    }

    public void forEachProperty(BiConsumer<String, Object> func) {
        if (this.map.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            func.accept(entry.getKey().toString(), entry.getValue());
        }
    }

    public <T> T get(String key) {
        return (T)this.map.get(key);
    }

    public <T> T get(String key, Class<T> type) {
        return Converts.convert(this.map.get(key), type);
    }

    public <T> T get(String key, Class<T> type, T defaultValue) {
        Object v = this.map.get(key);
        return null == v ? defaultValue : Converts.convert(v, type);
    }

    public JsonValue getValue(String key) {
        Object o = this.get(key);
        return null == o ? null : JsonValue.of(o);
    }

    public JsonArray getArray(String key) {
        List list = (List)this.get(key);
        return null == list ? null : new JsonArray(list);
    }

    public void getArray(String key, Consumer<JsonValue> func) {
        JsonArray a = this.getArray(key);
        if (null == a) {
            return;
        }
        a.forEach(func);
    }

    public <T> List<T> getList(String key) {
        return (List)this.get(key);
    }

    public Map<String, Object> getMap(String key) {
        return (Map)this.get(key);
    }

    public JsonObject getObject(String key) {
        Map map = (Map)this.get(key);
        return null == map ? null : new JsonObject(map);
    }

    public void getObject(String key, BiConsumer<String, Object> func) {
        Map map = (Map)this.get(key);
        if (null != map) {
            for (Map.Entry entry : map.entrySet()) {
                func.accept((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public String getString(String key) {
        return (String)this.map.get(key);
    }

    public String getString(String key, String defaultValue) {
        String s = (String)this.map.get(key);
        return Strings.isEmpty(s) ? defaultValue : s;
    }

    public Integer getInteger(String key) {
        return (Integer)this.get(key);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        Integer i = (Integer)this.get(key);
        return null == i ? defaultValue : i;
    }

    public Long getLong(String key) {
        return (Long)this.get(key);
    }

    public Long getLong(String key, Long defaultValue) {
        Long l = (Long)this.get(key);
        return null == l ? defaultValue : l;
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Boolean b = (Boolean)this.get(key);
        return null == b ? defaultValue : b;
    }

    public Float getFloat(String key) {
        return (Float)this.get(key);
    }

    public Float getFloat(String key, Float defaultValue) {
        Float f = (Float)this.get(key);
        return null == f ? defaultValue : f;
    }

    public Double getDouble(String key) {
        return (Double)this.get(key);
    }

    public Double getDouble(String key, Double defaultValue) {
        Double d = (Double)this.get(key);
        return null == d ? defaultValue : d;
    }

    public String toString() {
        return this.map.toString();
    }
}

