/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.json;

import java.io.InputStream;
import java.io.Reader;
import leap.lang.json.JsonParserByteArray;
import leap.lang.json.JsonParserException;
import leap.lang.json.JsonParserInputStream;
import leap.lang.json.JsonParserReader;
import leap.lang.json.JsonParserString;

class JsonParser {
    public static final int ACCEPT_SIMPLE_QUOTE = 1;
    public static final int ACCEPT_NON_QUOTE = 2;
    public static final int ACCEPT_NAN = 4;
    public static final int IGNORE_CONTROL_CHAR = 8;
    public static final int USE_INTEGER_STORAGE = 16;
    public static final int ACCEPT_LEADING_ZERO = 32;
    public static final int ACCEPT_USELESS_COMMA = 64;
    public static final int USE_HI_PRECISION_FLOAT = 128;
    public static final int ACCEPT_TAILLING_DATA = 256;
    public static final int MODE_PERMISSIVE = -1;
    public static final int MODE_RFC4627 = 400;
    public static final int MODE_JSON_SIMPLE = 448;
    public static final int MODE_STRICTEST = 144;
    public static int DEFAULT_PERMISSIVE_MODE = System.getProperty("JSON_SMART_SIMPLE") != null ? 448 : -1;
    private int mode;
    private JsonParserReader pStream;
    private JsonParserInputStream pSBintream;
    private JsonParserString pString;
    private JsonParserByteArray pBytes;

    public JsonParser() {
        this.mode = 448;
    }

    public JsonParser(int permissifMode) {
        this.mode = permissifMode;
    }

    public Object parse(String in) throws JsonParserException {
        if (this.pString == null) {
            this.pString = new JsonParserString(this.mode);
        }
        return this.pString.parse(in);
    }

    public Object parse(byte[] in) throws JsonParserException {
        if (this.pBytes == null) {
            this.pBytes = new JsonParserByteArray(this.mode);
        }
        return this.pBytes.parse(in);
    }

    public Object parse(Reader in) throws JsonParserException {
        if (this.pStream == null) {
            this.pStream = new JsonParserReader(this.mode);
        }
        return this.pStream.parse(in);
    }

    public Object parse(InputStream in) throws JsonParserException {
        if (this.pSBintream == null) {
            this.pSBintream = new JsonParserInputStream(this.mode);
        }
        return this.pSBintream.parse(in);
    }
}

