/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.json;

import java.text.DateFormat;
import leap.lang.naming.NamingStyle;
import leap.lang.naming.NamingStyles;
import leap.lang.time.DateFormats;

public class JsonSettings {
    public static JsonSettings MAX = new Builder().build();
    public static JsonSettings MIN = new Builder().setKeyQuoted(false).setIgnoreEmpty(true).setIgnoreNull(true).build();
    private final boolean keyQuoted;
    private final boolean ignoreNull;
    private final boolean ignoreFalse;
    private final boolean ignoreEmptyString;
    private final boolean ignoreEmptyArray;
    private final boolean nullToEmptyString;
    private final NamingStyle namingStyle;
    private final DateFormat dateFormat;

    public JsonSettings(boolean keyQuoted, boolean ignoreNull, boolean ignoreFalse, boolean ignoreEmptyString, boolean ignoreEmptyArray, NamingStyle namingStyle, DateFormat dateFormat) {
        this(keyQuoted, ignoreNull, ignoreFalse, ignoreEmptyString, ignoreEmptyArray, false, namingStyle, dateFormat);
    }

    public JsonSettings(boolean keyQuoted, boolean ignoreNull, boolean ignoreFalse, boolean ignoreEmptyString, boolean ignoreEmptyArray, boolean nullToEmptyString, NamingStyle namingStyle, DateFormat dateFormat) {
        this.keyQuoted = keyQuoted;
        this.ignoreNull = ignoreNull;
        this.ignoreFalse = ignoreFalse;
        this.ignoreEmptyString = ignoreEmptyString;
        this.ignoreEmptyArray = ignoreEmptyArray;
        this.namingStyle = namingStyle;
        this.dateFormat = dateFormat;
        this.nullToEmptyString = nullToEmptyString;
    }

    public boolean isKeyQuoted() {
        return this.keyQuoted;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }

    public boolean isIgnoreFalse() {
        return this.ignoreFalse;
    }

    public boolean isIgnoreEmptyString() {
        return this.ignoreEmptyString;
    }

    public boolean isIgnoreEmptyArray() {
        return this.ignoreEmptyArray;
    }

    public NamingStyle getNamingStyle() {
        return this.namingStyle;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public boolean isNullToEmptyString() {
        return this.nullToEmptyString;
    }

    public static final class Builder {
        private boolean keyQuoted = true;
        private boolean ignoreNull = false;
        private boolean ignoreFalse = false;
        private boolean ignoreEmptyString = false;
        private boolean ignoreEmptyArray = false;
        private boolean nullToEmptyString = false;
        private NamingStyle namingStyle = NamingStyles.RAW;
        private DateFormat dateFormat = null;

        public boolean isKeyQuoted() {
            return this.keyQuoted;
        }

        public Builder setKeyQuoted(boolean keyQuoted) {
            this.keyQuoted = keyQuoted;
            return this;
        }

        public boolean isIgnoreNull() {
            return this.ignoreNull;
        }

        public Builder setIgnoreNull(boolean ignoreNull) {
            this.ignoreNull = ignoreNull;
            return this;
        }

        public boolean isIgnoreFalse() {
            return this.ignoreFalse;
        }

        public Builder setIgnoreFalse(boolean ignoreFalse) {
            this.ignoreFalse = ignoreFalse;
            return this;
        }

        public Builder setIgnoreEmpty(boolean ignoreEmpty) {
            this.ignoreEmptyString = ignoreEmpty;
            this.ignoreEmptyArray = ignoreEmpty;
            return this;
        }

        public boolean isIgnoreEmptyString() {
            return this.ignoreEmptyString;
        }

        public void setIgnoreEmptyString(boolean ignoreEmptyString) {
            this.ignoreEmptyString = ignoreEmptyString;
        }

        public boolean isIgnoreEmptyArray() {
            return this.ignoreEmptyArray;
        }

        public void setIgnoreEmptyArray(boolean ignoreEmptyArray) {
            this.ignoreEmptyArray = ignoreEmptyArray;
        }

        public Builder ignoreEmpty() {
            return this.setIgnoreEmpty(true);
        }

        public Builder ignoreNull() {
            return this.setIgnoreNull(true);
        }

        public NamingStyle getNamingStyle() {
            return this.namingStyle;
        }

        public Builder setNamingStyle(NamingStyle namingStyle) {
            this.namingStyle = namingStyle;
            return this;
        }

        public DateFormat getDateFormat() {
            return this.dateFormat;
        }

        public Builder setDateFormat(String dateFormat) {
            this.dateFormat = null == dateFormat ? null : DateFormats.getFormat(dateFormat);
            return this;
        }

        public boolean isNullToEmptyString() {
            return this.nullToEmptyString;
        }

        public Builder setNullToEmptyString(boolean nullToEmptyString) {
            this.nullToEmptyString = nullToEmptyString;
            return this;
        }

        public Builder setSettings(JsonSettings settings) {
            this.keyQuoted = settings.keyQuoted;
            this.ignoreNull = settings.ignoreNull;
            this.ignoreFalse = settings.ignoreFalse;
            this.ignoreEmptyString = settings.ignoreEmptyString;
            this.ignoreEmptyArray = settings.ignoreEmptyArray;
            this.nullToEmptyString = settings.nullToEmptyString;
            this.namingStyle = settings.namingStyle;
            this.dateFormat = settings.dateFormat;
            return this;
        }

        public JsonSettings build() {
            return new JsonSettings(this.keyQuoted, this.ignoreNull, this.ignoreFalse, this.ignoreEmptyString, this.ignoreEmptyArray, this.nullToEmptyString, this.namingStyle, this.dateFormat);
        }
    }
}

