/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.json;

import java.util.List;
import java.util.Map;
import leap.lang.json.JsonArray;
import leap.lang.json.JsonObject;
import leap.lang.json.JsonScalar;

public interface JsonValue {
    public static final JsonValue NULL = () -> null;

    public static JsonValue of(Object raw) {
        if (null == raw) {
            return NULL;
        }
        if (raw instanceof JsonValue) {
            return (JsonValue)raw;
        }
        if (raw instanceof Map) {
            return new JsonObject((Map)raw);
        }
        if (raw instanceof List) {
            return new JsonArray((List)raw);
        }
        return new JsonScalar(raw);
    }

    public Object raw();

    default public boolean isNull() {
        return null == this.raw();
    }

    default public boolean isScalar() {
        return false;
    }

    default public boolean isArray() {
        return this.raw() instanceof List;
    }

    default public boolean isList() {
        return this.raw() instanceof List;
    }

    default public boolean isObject() {
        return this.raw() instanceof Map;
    }

    default public boolean isMap() {
        return this.raw() instanceof Map;
    }

    default public Object[] asArray() {
        return this.asList().toArray();
    }

    default public <T> List<T> asList() {
        throw new IllegalStateException("Not a list");
    }

    default public Map<String, Object> asMap() {
        throw new IllegalStateException("Not a map");
    }

    default public JsonArray asJsonArray() {
        throw new IllegalStateException("Not a json array");
    }

    default public JsonObject asJsonObject() {
        throw new IllegalStateException("Not an json object");
    }

    default public JsonScalar asJsonScalar() {
        throw new IllegalStateException("Not a scalar value");
    }

    default public String asString() {
        return (String)this.raw();
    }

    default public Long asLong() {
        return (Long)this.raw();
    }

    default public Integer asInteger() {
        return (Integer)this.raw();
    }

    default public Float asFloat() {
        return (Float)this.raw();
    }

    default public Double asDouble() {
        return (Double)this.raw();
    }
}

