/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.json;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import leap.lang.Strings;
import leap.lang.json.JsonStringable;
import leap.lang.naming.NamingStyle;

public interface JsonWriter {
    public static final int MAX_DEPTH = 100;
    public static final String HEX_PREFIX = "0x";
    public static final String NULL_STRING = "null";
    public static final String EMPTY_STRING = "\"\"";
    public static final char OPEN_ARRAY = '[';
    public static final char CLOSE_ARRAY = ']';
    public static final char OPEN_OBJECT = '{';
    public static final char CLOSE_OBJECT = '}';
    public static final char CLOSE_KEY = ':';
    public static final char DOUBLE_QUOTE = '\"';
    public static final char COMMA_CHAR = ',';

    public NamingStyle getNamingStyle();

    public int getMaxDepth();

    public boolean isKeyQuoted();

    public boolean isIgnoreEmptyString();

    public boolean isIgnoreEmptyArray();

    public boolean isIgnoreFalse();

    public boolean isIgnoreNull();

    public boolean isDetectCyclicReferences();

    public boolean isIgnoreCyclicReferences();

    public JsonWriter null_();

    public JsonWriter key(String var1);

    public JsonWriter keyUseNamingStyle(String var1);

    public JsonWriter value(boolean var1);

    public JsonWriter value(byte var1);

    public JsonWriter value(byte[] var1);

    public JsonWriter value(char var1);

    public JsonWriter value(short var1);

    public JsonWriter value(int var1);

    public JsonWriter value(long var1);

    public JsonWriter value(float var1);

    public JsonWriter value(double var1);

    public JsonWriter value(Number var1);

    public JsonWriter value(Date var1);

    public JsonWriter value(LocalDate var1);

    public JsonWriter value(LocalTime var1);

    public JsonWriter value(LocalDateTime var1);

    public JsonWriter value(String var1);

    public JsonWriter value(Object var1);

    public JsonWriter map(Map var1);

    public JsonWriter bean(Object var1);

    public JsonWriter separator();

    public JsonWriter raw(String var1);

    public JsonWriter startObject();

    public JsonWriter startObject(String var1);

    public JsonWriter endObject();

    public JsonWriter startArray();

    public JsonWriter startArray(String var1);

    public JsonWriter endArray();

    default public JsonWriter emptyArray() {
        return this.startArray().endArray();
    }

    default public JsonWriter propertyOptional(String key, JsonStringable o) {
        if (null != o) {
            this.property(key, o);
        }
        return this;
    }

    default public JsonWriter propertyOptional(String key, String v) {
        if (!Strings.isEmpty(v)) {
            this.property(key, v);
        }
        return this;
    }

    default public JsonWriter propertyOptional(String key, Boolean v) {
        if (null != v) {
            this.property(key, v);
        }
        return this;
    }

    default public JsonWriter propertyOptional(String key, Byte v) {
        if (null != v) {
            this.property(key, v);
        }
        return this;
    }

    default public JsonWriter propertyOptional(String key, Short v) {
        if (null != v) {
            this.property(key, v);
        }
        return this;
    }

    default public JsonWriter propertyOptional(String key, Integer v) {
        if (null != v) {
            this.property(key, v);
        }
        return this;
    }

    default public JsonWriter propertyOptional(String key, Long v) {
        if (null != v) {
            this.property(key, v);
        }
        return this;
    }

    default public JsonWriter propertyOptional(String key, Float v) {
        if (null != v) {
            this.property(key, v);
        }
        return this;
    }

    default public JsonWriter propertyOptional(String key, Double v) {
        if (null != v) {
            this.property(key, v);
        }
        return this;
    }

    default public JsonWriter propertyOptional(String key, Number v) {
        if (null != v) {
            this.property(key, v);
        }
        return this;
    }

    default public JsonWriter propertyOptional(String key, Date v) {
        if (null != v) {
            this.property(key, v);
        }
        return this;
    }

    default public JsonWriter propertyOptional(String key, Object v) {
        if (null != v) {
            this.property(key, v);
        }
        return this;
    }

    default public JsonWriter propertyOptional(String key, Map map) {
        if (null != map && !map.isEmpty()) {
            this.property(key, map);
        }
        return this;
    }

    default public JsonWriter propertyOptional(String key, String[] a) {
        return null == a || a.length == 0 ? this : this.property(key, a);
    }

    default public JsonWriter propertyOptional(String key, int[] a) {
        return null == a || a.length == 0 ? this : this.property(key, a);
    }

    default public JsonWriter propertyOptional(String key, long[] a) {
        return null == a || a.length == 0 ? this : this.property(key, a);
    }

    default public JsonWriter propertyOptional(String key, Number[] a) {
        return null == a || a.length == 0 ? this : this.property(key, a);
    }

    default public JsonWriter propertyOptional(String key, Object[] a) {
        return null == a || a.length == 0 ? this : this.property(key, a);
    }

    public JsonWriter propertyIgnorable(String var1, Object var2);

    public JsonWriter propertyIgnorable(String var1, String var2);

    public JsonWriter propertyIgnorable(String var1, boolean var2);

    default public JsonWriter property(String key, JsonStringable o) {
        this.key(key);
        if (null == o) {
            this.null_();
        } else {
            o.toJson(this);
        }
        return this;
    }

    default public JsonWriter property(String key, Runnable propertyWriter) {
        this.key(key);
        if (null == propertyWriter) {
            this.null_();
        } else {
            propertyWriter.run();
        }
        return this;
    }

    public JsonWriter property(String var1, String var2);

    public JsonWriter property(String var1, boolean var2);

    public JsonWriter property(String var1, byte var2);

    public JsonWriter property(String var1, short var2);

    public JsonWriter property(String var1, int var2);

    public JsonWriter property(String var1, long var2);

    public JsonWriter property(String var1, float var2);

    public JsonWriter property(String var1, double var2);

    public JsonWriter property(String var1, Number var2);

    public JsonWriter property(String var1, Date var2);

    public JsonWriter property(String var1, Object var2);

    public JsonWriter property(String var1, Map var2);

    default public JsonWriter property(String key, String[] a) {
        return this.key(key).array(a);
    }

    default public JsonWriter property(String key, int[] a) {
        return this.key(key).array(a);
    }

    default public JsonWriter property(String key, long[] a) {
        return this.key(key).array(a);
    }

    default public JsonWriter property(String key, Number[] a) {
        return this.key(key).array(a);
    }

    default public JsonWriter property(String key, Object[] a) {
        return this.key(key).array(a);
    }

    default public JsonWriter property(String key, Iterable<Object> a) {
        return this.key(key).array(a);
    }

    default public JsonWriter propertyString(String key, Iterable<String> a) {
        return this.key(key).arrayString(a);
    }

    default public JsonWriter propertyStringOptional(String key, Collection<String> a) {
        return null == a || a.size() == 0 ? this : this.property(key, a);
    }

    default public JsonWriter propertyJsonable(String key, JsonStringable ... array) {
        this.key(key).startArray();
        if (null != array) {
            int i = 0;
            for (JsonStringable o : array) {
                o.toJson(this);
                if (i < array.length - 1) {
                    this.separator();
                }
                ++i;
            }
        }
        return this.endArray();
    }

    default public JsonWriter propertyJsonable(String key, Iterable<? extends JsonStringable> iterable) {
        this.key(key).startArray();
        if (null != iterable) {
            Iterator<? extends JsonStringable> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                JsonStringable o = iterator.next();
                o.toJson(this);
                if (!iterator.hasNext()) continue;
                this.separator();
            }
        }
        return this.endArray();
    }

    default public JsonWriter propertyJsonableOptional(String key, Collection<? extends JsonStringable> array) {
        if (null == array || array.isEmpty()) {
            return this;
        }
        return this.propertyJsonable(key, array);
    }

    public JsonWriter array(String ... var1);

    public JsonWriter objectArray(Object var1) throws IllegalStateException;

    public JsonWriter arrayIgnoreEmptyItem(String ... var1);

    public JsonWriter array(short ... var1);

    public JsonWriter array(int ... var1);

    public JsonWriter array(long ... var1);

    public JsonWriter array(float ... var1);

    public JsonWriter array(double ... var1);

    public JsonWriter array(Number ... var1);

    public JsonWriter array(Date ... var1);

    public JsonWriter array(Iterable<?> var1);

    public JsonWriter array(Iterator<?> var1);

    public JsonWriter array(Object[] var1);

    default public <T> JsonWriter array(Iterable<T> a, Consumer<T> itemWriter) {
        this.startArray();
        if (null != a) {
            int i = 0;
            for (T item : a) {
                if (i > 0) {
                    this.separator();
                } else {
                    ++i;
                }
                itemWriter.accept(item);
            }
        }
        this.endArray();
        return this;
    }

    default public <T> JsonWriter array(T[] a, Consumer<T> itemWriter) {
        this.startArray();
        if (null != a) {
            for (int i = 0; i < a.length; ++i) {
                T item = a[i];
                if (i > 0) {
                    this.separator();
                }
                itemWriter.accept(item);
            }
        }
        this.endArray();
        return this;
    }

    public JsonWriter arrayString(Iterable<String> var1);

    default public JsonWriter arrayJsonable(JsonStringable ... array) {
        for (JsonStringable o : array) {
            o.toJson(this);
        }
        return this;
    }
}

