/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.json;

import leap.lang.json.JsonSettings;
import leap.lang.json.JsonWriter;
import leap.lang.json.JsonWriterCreator;
import leap.lang.json.JsonWriterImpl;
import leap.lang.naming.NamingStyle;
import leap.lang.naming.NamingStyles;

class JsonWriterCreatorImpl
implements JsonWriterCreator {
    private final JsonSettings.Builder settings = new JsonSettings.Builder();
    private final Appendable out;
    protected boolean detectCyclicReferences = true;
    protected boolean ignoreCyclicReferences = true;
    protected int maxDepth = 100;

    public JsonWriterCreatorImpl(Appendable out) {
        this.out = out;
    }

    @Override
    public JsonWriterCreator setDetectCyclicReferences(boolean detectCyclicReferences) {
        this.detectCyclicReferences = detectCyclicReferences;
        return this;
    }

    @Override
    public JsonWriterCreator setIgnoreCyclicREferences(boolean ignoreCyclicReferences) {
        this.ignoreCyclicReferences = ignoreCyclicReferences;
        return this;
    }

    @Override
    public JsonWriterCreator setKeyQuoted(boolean keyQuoted) {
        this.settings.setKeyQuoted(keyQuoted);
        return this;
    }

    @Override
    public JsonWriterCreator setIgnoreNull(boolean ignoreNull) {
        this.settings.setIgnoreNull(ignoreNull);
        return this;
    }

    @Override
    public JsonWriterCreator setIgnoreFalse(boolean ignoreFalse) {
        this.settings.setIgnoreFalse(ignoreFalse);
        return this;
    }

    @Override
    public JsonWriterCreator setIgnoreEmptyString(boolean ignoreEmptyString) {
        this.settings.setIgnoreEmptyString(ignoreEmptyString);
        return this;
    }

    @Override
    public JsonWriterCreator setIgnoreEmptyArray(boolean ignoreEmptyArray) {
        this.settings.setIgnoreEmptyArray(ignoreEmptyArray);
        return this;
    }

    @Override
    public JsonWriterCreator setMaxDepth(int depth) {
        this.maxDepth = depth;
        return this;
    }

    @Override
    public JsonWriterCreator setNamingStyle(NamingStyle namingStyle) {
        this.settings.setNamingStyle(namingStyle);
        return this;
    }

    @Override
    public JsonWriterCreator setSettings(JsonSettings settings) {
        if (null != settings) {
            this.settings.setSettings(settings);
        }
        return this;
    }

    @Override
    public JsonWriter create() {
        if (null == this.settings.getNamingStyle()) {
            this.settings.setNamingStyle(NamingStyles.RAW);
        }
        return new JsonWriterImpl(this.settings.build(), this.out, this.detectCyclicReferences, this.ignoreCyclicReferences, this.maxDepth);
    }
}

