/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.json;

import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import leap.lang.Arrays2;
import leap.lang.Enums;
import leap.lang.Strings;
import leap.lang.beans.BeanProperty;
import leap.lang.beans.BeanType;
import leap.lang.codec.Base64;
import leap.lang.json.JsonException;
import leap.lang.json.JsonField;
import leap.lang.json.JsonFormat;
import leap.lang.json.JsonIgnore;
import leap.lang.json.JsonName;
import leap.lang.json.JsonSettings;
import leap.lang.json.JsonStringable;
import leap.lang.json.JsonType;
import leap.lang.json.JsonWriter;
import leap.lang.naming.NamingStyle;
import leap.lang.time.DateFormats;

public class JsonWriterImpl
implements JsonWriter {
    private static final Integer zero = new Integer(0);
    static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final JsonSettings settings;
    private final Appendable out;
    private final DateFormat dateFormat;
    private final boolean detectCyclicReferences;
    private final boolean ignoreCyclicReferences;
    private final int maxDepth;
    private boolean startProperty;
    private int depth;
    private IdentityHashMap<Object, Integer> references;

    public JsonWriterImpl(JsonSettings settings, Appendable out, boolean detectCyclicReferences, boolean ignoreCyclicReferences, int maxDepth) {
        this.settings = settings;
        this.out = out;
        this.dateFormat = settings.getDateFormat();
        this.detectCyclicReferences = detectCyclicReferences;
        this.ignoreCyclicReferences = ignoreCyclicReferences;
        int n = this.maxDepth = this.depth <= 0 ? 100 : maxDepth;
        if (detectCyclicReferences) {
            this.references = new IdentityHashMap();
        }
    }

    @Override
    public NamingStyle getNamingStyle() {
        return this.settings.getNamingStyle();
    }

    @Override
    public int getMaxDepth() {
        return this.maxDepth;
    }

    @Override
    public boolean isKeyQuoted() {
        return this.settings.isKeyQuoted();
    }

    @Override
    public boolean isIgnoreEmptyString() {
        return this.settings.isIgnoreEmptyString();
    }

    @Override
    public boolean isIgnoreEmptyArray() {
        return this.settings.isIgnoreEmptyArray();
    }

    @Override
    public boolean isIgnoreFalse() {
        return this.settings.isIgnoreFalse();
    }

    @Override
    public boolean isIgnoreNull() {
        return this.settings.isIgnoreNull();
    }

    @Override
    public boolean isDetectCyclicReferences() {
        return this.detectCyclicReferences;
    }

    @Override
    public boolean isIgnoreCyclicReferences() {
        return this.ignoreCyclicReferences;
    }

    @Override
    public JsonWriter startObject() {
        try {
            this.out.append('{');
            this.startProperty = true;
        }
        catch (IOException e) {
            this.wrapAndThrow(e);
        }
        return this;
    }

    @Override
    public JsonWriter startObject(String key) {
        return this.key(key).startObject();
    }

    @Override
    public JsonWriter propertyIgnorable(String key, Object v) {
        if (this.isIgnoreNull() && null == v) {
            return this;
        }
        if (this.isIgnoreEmptyString() && v instanceof CharSequence) {
            CharSequence cs = (CharSequence)v;
            if (cs.length() == 0) {
                return this;
            }
            return this.key(key).value(cs.toString());
        }
        if (this.isIgnoreEmptyArray()) {
            if (v instanceof Object[]) {
                Object[] a = (Object[])v;
                if (a.length == 0) {
                    return this;
                }
                return this.key(key).array(a);
            }
            if (v instanceof Iterable) {
                Iterator it = ((Iterable)v).iterator();
                if (!it.hasNext()) {
                    return this;
                }
                return this.key(key).array(it);
            }
            if (v.getClass().isArray()) {
                int i = Array.getLength(v);
                if (i == 0) {
                    return this;
                }
                return this.key(key).objectArray(v);
            }
        }
        if (this.isIgnoreFalse() && v instanceof Boolean) {
            if (v == Boolean.FALSE) {
                return this;
            }
            return this.property(key, (Boolean)v);
        }
        return this.property(key, v);
    }

    @Override
    public JsonWriter propertyIgnorable(String key, String s) {
        if (this.isIgnoreNull() && null == s) {
            return this;
        }
        if (this.isIgnoreEmptyString() && s.length() == 0) {
            return this;
        }
        return this.property(key, s);
    }

    @Override
    public JsonWriter propertyIgnorable(String key, boolean b) {
        if (this.isIgnoreFalse() && !b) {
            return this;
        }
        return this.property(key, b);
    }

    @Override
    public JsonWriter property(String key, String stringValue) {
        if (this.settings.isNullToEmptyString() && null == stringValue) {
            stringValue = "";
        }
        return this.key(key).value(stringValue);
    }

    @Override
    public JsonWriter property(String key, boolean boolValue) {
        return this.key(key).value(boolValue);
    }

    @Override
    public JsonWriter property(String key, byte byteValue) {
        return this.key(key).value(byteValue);
    }

    @Override
    public JsonWriter property(String key, short shortValue) {
        return this.key(key).value(shortValue);
    }

    @Override
    public JsonWriter property(String key, int intValue) {
        return this.key(key).value(intValue);
    }

    @Override
    public JsonWriter property(String key, long longValue) {
        return this.key(key).value(longValue);
    }

    @Override
    public JsonWriter property(String key, float floatValue) {
        return this.key(key).value(floatValue);
    }

    @Override
    public JsonWriter property(String key, double doubleValue) {
        return this.key(key).value(doubleValue);
    }

    public JsonWriter property(String key, BigDecimal decimalValue) {
        return this.key(key).value(decimalValue);
    }

    @Override
    public JsonWriter property(String key, Number numberValue) {
        return this.key(key).value(numberValue);
    }

    @Override
    public JsonWriter property(String key, Date dateValue) {
        return this.key(key).value(dateValue);
    }

    @Override
    public JsonWriter property(String key, Object v) {
        return this.key(key).value(v);
    }

    @Override
    public JsonWriter property(String key, Map v) {
        return this.key(key).map(v);
    }

    @Override
    public JsonWriter endObject() {
        try {
            this.out.append('}');
            this.startProperty = false;
        }
        catch (IOException e) {
            this.wrapAndThrow(e);
        }
        return this;
    }

    @Override
    public JsonWriter array(Date ... array) {
        this.startArray();
        if (null != array) {
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    this.separator();
                }
                this.value(array[i]);
            }
        }
        this.endArray();
        return this;
    }

    @Override
    public JsonWriter arrayString(Iterable<String> array) {
        this.startArray();
        if (null != array) {
            Iterator<String> it = array.iterator();
            int i = 0;
            while (it.hasNext()) {
                if (i > 0) {
                    this.separator();
                } else {
                    ++i;
                }
                this.value(it.next());
            }
        }
        this.endArray();
        return this;
    }

    @Override
    public JsonWriter array(double ... array) {
        this.startArray();
        if (null != array) {
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    this.separator();
                }
                this.value(array[i]);
            }
        }
        this.endArray();
        return this;
    }

    @Override
    public JsonWriter array(float ... array) {
        this.startArray();
        if (null != array) {
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    this.separator();
                }
                this.value(array[i]);
            }
        }
        this.endArray();
        return this;
    }

    @Override
    public JsonWriter array(Number ... array) {
        this.startArray();
        if (null != array) {
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    this.separator();
                }
                this.value(array[i]);
            }
        }
        this.endArray();
        return this;
    }

    @Override
    public JsonWriter array(short ... array) {
        this.startArray();
        if (null != array) {
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    this.separator();
                }
                this.value(array[i]);
            }
        }
        this.endArray();
        return this;
    }

    @Override
    public JsonWriter array(int ... array) {
        this.startArray();
        if (null != array) {
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                if (i <= 0) continue;
                this.separator();
            }
        }
        this.endArray();
        return this;
    }

    @Override
    public JsonWriter array(long ... array) {
        this.startArray();
        if (null != array) {
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    this.separator();
                }
                this.value(array[i]);
            }
        }
        this.endArray();
        return this;
    }

    @Override
    public JsonWriter array(String ... array) {
        this.startArray();
        if (null != array) {
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    this.separator();
                }
                this.value(array[i]);
            }
        }
        this.endArray();
        return this;
    }

    @Override
    public JsonWriter array(Iterable<?> array) {
        return this.array(null == array ? (Iterator<?>)null : array.iterator());
    }

    @Override
    public JsonWriter array(Iterator<?> array) {
        this.startArray();
        if (null != array) {
            int i = 0;
            while (array.hasNext()) {
                if (i > 0) {
                    this.separator();
                } else {
                    ++i;
                }
                this.value(array.next());
            }
        }
        this.endArray();
        return this;
    }

    @Override
    public JsonWriter array(Object[] array) {
        this.startArray();
        if (null != array) {
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    this.separator();
                }
                this.value(array[i]);
            }
        }
        this.endArray();
        return this;
    }

    @Override
    public JsonWriter objectArray(Object array) throws IllegalStateException {
        this.startArray();
        if (null != array) {
            if (!array.getClass().isArray()) {
                throw new IllegalStateException("The given object is not an array");
            }
            int len = Array.getLength(array);
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    this.separator();
                }
                this.value(Array.get(array, i));
            }
        }
        this.endArray();
        return this;
    }

    @Override
    public JsonWriter arrayIgnoreEmptyItem(String ... array) {
        this.startArray();
        if (null != array) {
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                String s = array[i];
                if (Strings.isEmpty(s)) continue;
                if (i > 0) {
                    this.separator();
                }
                this.value(s);
            }
        }
        this.endArray();
        return this;
    }

    @Override
    public JsonWriter startArray() {
        try {
            this.out.append('[');
        }
        catch (IOException e) {
            this.wrapAndThrow(e);
        }
        return this;
    }

    @Override
    public JsonWriter startArray(String key) {
        return this.key(key).startArray();
    }

    @Override
    public JsonWriter endArray() {
        try {
            this.out.append(']');
        }
        catch (IOException e) {
            this.wrapAndThrow(e);
        }
        return this;
    }

    @Override
    public JsonWriter value(boolean bool) {
        try {
            this.out.append(String.valueOf(bool));
        }
        catch (IOException e) {
            this.wrapAndThrow(e);
        }
        return this;
    }

    @Override
    public JsonWriter value(byte b) {
        try {
            this.out.append(String.valueOf(b));
        }
        catch (IOException e) {
            this.wrapAndThrow(e);
        }
        return this;
    }

    @Override
    public JsonWriter value(char c) {
        return this.value(String.valueOf(c));
    }

    @Override
    public JsonWriter value(byte[] bytes) {
        try {
            if (null == bytes || bytes.length == 0) {
                this.out.append("\"\"");
            } else {
                this.out.append('\"').append(Base64.encode(bytes)).append('\"');
            }
        }
        catch (IOException e) {
            this.wrapAndThrow(e);
        }
        return this;
    }

    @Override
    public JsonWriter value(short s) {
        return this.raw(String.valueOf(s));
    }

    @Override
    public JsonWriter value(int i) {
        return this.raw(String.valueOf(i));
    }

    @Override
    public JsonWriter value(long l) {
        return this.raw(String.valueOf(l));
    }

    @Override
    public JsonWriter value(float f) {
        return this.raw(String.valueOf(f));
    }

    @Override
    public JsonWriter value(double d) {
        return this.raw(String.valueOf(d));
    }

    public JsonWriter value(BigDecimal decimal) {
        try {
            this.out.append(null == decimal ? "null" : decimal.toString());
        }
        catch (IOException e) {
            this.wrapAndThrow(e);
        }
        return this;
    }

    @Override
    public JsonWriter value(Number number) {
        try {
            this.out.append(null == number ? "null" : String.valueOf(number));
        }
        catch (IOException e) {
            this.wrapAndThrow(e);
        }
        return this;
    }

    @Override
    public JsonWriter value(Date date) {
        try {
            if (null == date) {
                this.out.append("null");
            } else if (null != this.dateFormat) {
                this.out.append('\"').append(this.dateFormat.format(date)).append('\"');
            } else {
                this.out.append(String.valueOf(date.getTime()));
            }
        }
        catch (IOException e) {
            this.wrapAndThrow(e);
        }
        return this;
    }

    @Override
    public JsonWriter value(LocalDate date) {
        try {
            this.out.append(null == date ? "null" : date.toString());
        }
        catch (IOException e) {
            this.wrapAndThrow(e);
        }
        return this;
    }

    @Override
    public JsonWriter value(LocalTime time) {
        try {
            this.out.append(null == time ? "null" : time.toString());
        }
        catch (IOException e) {
            this.wrapAndThrow(e);
        }
        return this;
    }

    @Override
    public JsonWriter value(LocalDateTime dateTime) {
        try {
            this.out.append(null == dateTime ? "null" : dateTime.toString());
        }
        catch (IOException e) {
            this.wrapAndThrow(e);
        }
        return this;
    }

    @Override
    public JsonWriter key(String key) {
        try {
            if (this.startProperty) {
                this.startProperty = false;
            } else {
                this.out.append(',');
            }
            if (this.isKeyQuoted()) {
                this.out.append('\"').append(key).append('\"');
            } else {
                this.out.append(key);
            }
            this.out.append(':');
        }
        catch (IOException e) {
            this.wrapAndThrow(e);
        }
        return this;
    }

    @Override
    public JsonWriter keyUseNamingStyle(String key) {
        return this.key(this.getNamingStyle().of(key));
    }

    @Override
    public JsonWriter value(String string) {
        try {
            if (string == null) {
                this.out.append("null");
            } else if (string.length() == 0) {
                this.out.append("\"\"");
            } else {
                char c = '\u0000';
                int len = string.length();
                this.out.append('\"');
                block11: for (int i = 0; i < len; ++i) {
                    c = string.charAt(i);
                    switch (c) {
                        case '\\': {
                            this.out.append("\\\\");
                            continue block11;
                        }
                        case '\"': {
                            this.out.append("\\\"");
                            continue block11;
                        }
                        case '\b': {
                            this.out.append("\\b");
                            continue block11;
                        }
                        case '\t': {
                            this.out.append("\\t");
                            continue block11;
                        }
                        case '\n': {
                            this.out.append("\\n");
                            continue block11;
                        }
                        case '\f': {
                            this.out.append("\\f");
                            continue block11;
                        }
                        case '\r': {
                            this.out.append("\\r");
                            continue block11;
                        }
                        default: {
                            this.out.append(c);
                        }
                    }
                }
                this.out.append('\"');
            }
        }
        catch (IOException e) {
            this.wrapAndThrow(e);
        }
        return this;
    }

    @Override
    public JsonWriter null_() {
        try {
            this.out.append("null");
        }
        catch (IOException e) {
            this.wrapAndThrow(e);
        }
        return this;
    }

    @Override
    public JsonWriter value(Object v) {
        return this.value(v, this::bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonWriter value(Object v, Consumer<Object> beanWriter) {
        ++this.depth;
        if (this.depth == this.maxDepth) {
            throw new JsonException("Exceed max depth " + this.depth);
        }
        try {
            if (null == v) {
                JsonWriter jsonWriter = this.null_();
                return jsonWriter;
            }
            if (v instanceof String) {
                JsonWriter jsonWriter = this.value((String)v);
                return jsonWriter;
            }
            if (v instanceof Byte) {
                JsonWriter jsonWriter = this.value((Byte)v);
                return jsonWriter;
            }
            if (v instanceof Boolean) {
                JsonWriter jsonWriter = this.value((Boolean)v);
                return jsonWriter;
            }
            if (v instanceof Character) {
                JsonWriter jsonWriter = this.value(((Character)v).charValue());
                return jsonWriter;
            }
            if (v instanceof Number) {
                JsonWriter jsonWriter = this.value((Number)v);
                return jsonWriter;
            }
            if (v instanceof Date) {
                JsonWriter jsonWriter = this.value((Date)v);
                return jsonWriter;
            }
            if (v instanceof LocalDate) {
                JsonWriter jsonWriter = this.value((LocalDate)v);
                return jsonWriter;
            }
            if (v instanceof LocalDateTime) {
                JsonWriter jsonWriter = this.value((LocalDateTime)v);
                return jsonWriter;
            }
            if (v instanceof LocalTime) {
                JsonWriter jsonWriter = this.value((LocalTime)v);
                return jsonWriter;
            }
            if (v instanceof Class) {
                JsonWriter jsonWriter = this.value(((Class)v).getName());
                return jsonWriter;
            }
            if (v instanceof byte[]) {
                JsonWriter jsonWriter = this.value((byte[])v);
                return jsonWriter;
            }
            if (v instanceof Enum) {
                JsonWriter jsonWriter = this.value(Enums.getValue((Enum)v));
                return jsonWriter;
            }
            if (v instanceof Object[]) {
                JsonWriter jsonWriter = this.array((Object[])v);
                return jsonWriter;
            }
            if (v instanceof Iterable) {
                JsonWriter jsonWriter = this.array((Iterable)v);
                return jsonWriter;
            }
            if (v instanceof Iterator) {
                JsonWriter jsonWriter = this.array((Iterator)v);
                return jsonWriter;
            }
            if (v.getClass().isArray()) {
                JsonWriter jsonWriter = this.objectArray(v);
                return jsonWriter;
            }
            if (v instanceof JsonStringable) {
                ((JsonStringable)v).toJson(this);
                JsonWriterImpl jsonWriterImpl = this;
                return jsonWriterImpl;
            }
            if (v instanceof Map) {
                JsonWriter jsonWriter = this.map((Map)v);
                return jsonWriter;
            }
            if (this.detectCyclicReferences) {
                if (this.references.containsKey(v)) {
                    if (this.ignoreCyclicReferences) {
                        JsonWriter jsonWriter = this.null_();
                        return jsonWriter;
                    }
                    throw new JsonException("Found cyclic reference : " + v.toString());
                }
                this.references.put(v, zero);
            }
            beanWriter.accept(v);
            if (this.detectCyclicReferences) {
                this.references.remove(v);
            }
            JsonWriterImpl jsonWriterImpl = this;
            return jsonWriterImpl;
        }
        finally {
            --this.depth;
        }
    }

    @Override
    public JsonWriter map(Map map) {
        if (null == map) {
            return this.null_();
        }
        this.startObject();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item;
            Map.Entry entry = item = iterator.next();
            String key = this.ns(entry.getKey().toString());
            Object val = entry.getValue();
            if (this.isIgnoreNull() && val == null || val != null && (val instanceof String && this.isIgnoreEmptyString() && Strings.isEmpty((String)val) || val.getClass().isArray() && this.isIgnoreEmptyArray() && Arrays2.isEmpty((Object[])val) || val instanceof Boolean && this.isIgnoreFalse() && Objects.equals(val, Boolean.FALSE))) continue;
            if (this.settings.isNullToEmptyString() && val == null) {
                val = "";
            }
            this.property(key, val);
        }
        this.endObject();
        return this;
    }

    @Override
    public JsonWriter bean(Object bean) {
        return this.bean(bean, null);
    }

    protected JsonWriter bean(Object bean, JsonType type) {
        if (null == bean) {
            return this.null_();
        }
        this.startObject();
        try {
            BeanType beanType = BeanType.of(bean.getClass());
            if (null == type && !bean.getClass().isInterface()) {
                type = bean.getClass().getSuperclass().getAnnotation(JsonType.class);
            }
            if (null != type) {
                String metaPropertyName = Strings.firstNotEmpty(type.property(), type.meta().getDefaultPropertyName());
                if (type.meta() == JsonType.MetaType.CLASS_NAME) {
                    this.property(metaPropertyName, bean.getClass().getName());
                } else {
                    boolean typed = false;
                    for (JsonType.SubType subType : type.types()) {
                        if (!subType.type().equals(bean.getClass())) continue;
                        typed = true;
                        if (beanType.hasProperty(metaPropertyName)) break;
                        this.property(metaPropertyName, subType.name());
                        break;
                    }
                    if (!typed) {
                        throw new JsonException("No type name has been defined for class '" + bean.getClass() + "' in super class");
                    }
                }
            }
            for (BeanProperty prop : beanType.getProperties()) {
                Object propValue;
                JsonField jsonField;
                if (prop.isTransient() || !prop.isReadable() || !prop.isField() || null == (jsonField = prop.getAnnotation(JsonField.class)) && prop.isAnnotationPresent(JsonIgnore.class)) continue;
                String propName = prop.getName();
                JsonName named = prop.getAnnotation(JsonName.class);
                if (null != named) {
                    propName = named.value();
                }
                if (null == (propValue = jsonField != null && !jsonField.useGetter() ? prop.getReflectField().getValue(bean, false) : prop.getValue(bean)) && this.isIgnoreNull() || this.isIgnoreEmptyString() && Strings.isNullOrBlank(propValue)) continue;
                if (prop.getField().getType().equals(String.class) && this.settings.isNullToEmptyString() && null == propValue) {
                    propValue = "";
                }
                this.keyUseNamingStyle(propName);
                if (this.writeDateValue(prop, propValue)) continue;
                this.value(propValue, v -> this.bean(v, prop.getType().getAnnotation(JsonType.class)));
            }
        }
        catch (JsonException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonException("Error writing json value : " + bean.getClass().getName(), e);
        }
        return this.endObject();
    }

    protected boolean writeDateValue(BeanProperty bp, Object value) {
        if (value instanceof Date) {
            JsonFormat a = bp.getAnnotation(JsonFormat.class);
            if (null == a) {
                this.value((Date)value);
            } else {
                DateFormat dateFormat = DateFormats.getFormat(a.value());
                this.value(dateFormat.format((Date)value));
            }
            return true;
        }
        return false;
    }

    @Override
    public JsonWriter separator() {
        try {
            this.out.append(',');
        }
        catch (IOException e) {
            this.wrapAndThrow(e);
        }
        return this;
    }

    @Override
    public JsonWriter raw(String string) {
        try {
            this.out.append(string);
        }
        catch (IOException e) {
            this.wrapAndThrow(e);
        }
        return this;
    }

    public String toString() {
        return this.out.toString();
    }

    protected String ns(String s) {
        return this.getNamingStyle().of(s);
    }

    private void wrapAndThrow(IOException e) {
        throw new JsonException(e.getMessage(), e);
    }
}

