/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.jsoup.nodes;

import java.util.Map;
import leap.lang.jsoup.helper.Validate;
import leap.lang.jsoup.nodes.Document;
import leap.lang.jsoup.nodes.Entities;

public class Attribute
implements Map.Entry<String, String>,
Cloneable {
    private String key;
    private String originKey;
    private String value;
    private Character quotedCharacter;

    public Attribute(String key, String value) {
        this(key, value, Character.valueOf('\"'));
    }

    public Attribute(String key, String value, Character quotedCharacter) {
        Validate.notEmpty(key);
        Validate.notNull(value);
        this.key = key.trim().toLowerCase();
        this.originKey = key.trim();
        this.value = value;
        this.quotedCharacter = quotedCharacter;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        Validate.notEmpty(key);
        this.key = key.trim().toLowerCase();
    }

    public String getOriginKey() {
        return this.originKey;
    }

    public void setOriginKey(String originKey) {
        this.originKey = originKey;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String setValue(String value) {
        Validate.notNull(value);
        String old = this.value;
        this.value = value;
        return old;
    }

    public Character getQuotedCharacter() {
        return this.quotedCharacter;
    }

    public void setQuotedCharacter(Character quotedCharacter) {
        this.quotedCharacter = quotedCharacter;
    }

    public String html() {
        return this.key + "=\"" + Entities.escape(this.value, new Document("").outputSettings()) + "\"";
    }

    protected void html(StringBuilder accum, Document.OutputSettings out) {
        accum.append(this.key).append("=\"").append(Entities.escape(this.value, out)).append("\"");
    }

    public String toString() {
        return this.html();
    }

    public static Attribute createFromEncoded(String unencodedKey, String encodedValue) {
        String value = Entities.unescape(encodedValue, true);
        return new Attribute(unencodedKey, value);
    }

    protected boolean isDataAttribute() {
        return this.key.startsWith("data-") && this.key.length() > "data-".length();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        if (this.key != null ? !this.key.equals(attribute.key) : attribute.key != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(attribute.value) : attribute.value != null);
    }

    @Override
    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public Attribute clone() {
        try {
            return (Attribute)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

