/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.jsoup.nodes;

import leap.lang.jsoup.helper.StringUtil;
import leap.lang.jsoup.helper.Validate;
import leap.lang.jsoup.nodes.Document;
import leap.lang.jsoup.nodes.Node;

public class DocumentType
extends Node {
    private final String declaration;

    public DocumentType(String name, String publicId, String systemId, String baseUri) {
        this(null, name, publicId, systemId, baseUri);
    }

    public DocumentType(String declaration, String name, String publicId, String systemId, String baseUri) {
        super(baseUri);
        Validate.notEmpty(name);
        this.declaration = declaration;
        this.attr("name", name);
        this.attr("publicId", publicId);
        this.attr("systemId", systemId);
    }

    @Override
    public String nodeName() {
        return "#doctype";
    }

    @Override
    void outerHtmlHead(StringBuilder accum, int depth, Document.OutputSettings out) {
        if (null == this.declaration) {
            accum.append("<!DOCTYPE ");
        } else {
            accum.append("<!").append(this.declaration).append(" ");
        }
        accum.append(this.attr("name"));
        if (!StringUtil.isBlank(this.attr("publicId"))) {
            accum.append(" PUBLIC \"").append(this.attr("publicId")).append("\"");
        }
        if (!StringUtil.isBlank(this.attr("systemId"))) {
            accum.append(" \"").append(this.attr("systemId")).append("\"");
        }
        accum.append('>');
    }

    @Override
    void outerHtmlTail(StringBuilder accum, int depth, Document.OutputSettings out) {
    }
}

