/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.jsoup.parser;

import java.util.List;
import leap.lang.jsoup.nodes.Document;
import leap.lang.jsoup.nodes.Element;
import leap.lang.jsoup.nodes.Node;
import leap.lang.jsoup.parser.CharacterReader;
import leap.lang.jsoup.parser.HtmlParseMode;
import leap.lang.jsoup.parser.HtmlTreeBuilder;
import leap.lang.jsoup.parser.ParseError;
import leap.lang.jsoup.parser.ParseErrorList;
import leap.lang.jsoup.parser.Tokeniser;
import leap.lang.jsoup.parser.TreeBuilder;
import leap.lang.jsoup.parser.XmlTreeBuilder;

public class Parser {
    private static final int DEFAULT_MAX_ERRORS = 0;
    private TreeBuilder treeBuilder;
    private int maxErrors = 0;
    private ParseErrorList errors;

    public Parser(TreeBuilder treeBuilder) {
        this.treeBuilder = treeBuilder;
    }

    public Document parseInput(String html, String baseUri) {
        this.errors = this.isTrackErrors() ? ParseErrorList.tracking(this.maxErrors) : ParseErrorList.noTracking();
        Document doc = this.treeBuilder.parse(html, baseUri, this.errors);
        return doc;
    }

    public TreeBuilder getTreeBuilder() {
        return this.treeBuilder;
    }

    public Parser setTreeBuilder(TreeBuilder treeBuilder) {
        this.treeBuilder = treeBuilder;
        return this;
    }

    public boolean isTrackErrors() {
        return this.maxErrors > 0;
    }

    public Parser setTrackErrors(int maxErrors) {
        this.maxErrors = maxErrors;
        return this;
    }

    public List<ParseError> getErrors() {
        return this.errors;
    }

    public static Document parse(String html, String baseUri) {
        HtmlTreeBuilder treeBuilder = new HtmlTreeBuilder();
        return ((TreeBuilder)treeBuilder).parse(html, baseUri, ParseErrorList.noTracking());
    }

    public static Document parse(String html, String baseUri, HtmlParseMode parseModel) {
        HtmlTreeBuilder treeBuilder = new HtmlTreeBuilder(parseModel);
        return ((TreeBuilder)treeBuilder).parse(html, baseUri, ParseErrorList.noTracking());
    }

    public static List<Node> parseFragment(String fragmentHtml, Element context, String baseUri) {
        HtmlTreeBuilder treeBuilder = new HtmlTreeBuilder();
        return treeBuilder.parseFragment(fragmentHtml, context, baseUri, ParseErrorList.noTracking());
    }

    public static List<Node> parseXmlFragment(String fragmentXml, String baseUri) {
        XmlTreeBuilder treeBuilder = new XmlTreeBuilder();
        return treeBuilder.parseFragment(fragmentXml, baseUri, ParseErrorList.noTracking());
    }

    public static Document parseBodyFragment(String bodyHtml, String baseUri) {
        Node[] nodes;
        Document doc = Document.createShell(baseUri);
        Element body = doc.body();
        List<Node> nodeList = Parser.parseFragment(bodyHtml, body, baseUri);
        for (Node node : nodes = nodeList.toArray(new Node[nodeList.size()])) {
            body.appendChild(node);
        }
        return doc;
    }

    public static String unescapeEntities(String string, boolean inAttribute) {
        Tokeniser tokeniser = new Tokeniser(new CharacterReader(string), ParseErrorList.noTracking());
        return tokeniser.unescapeEntities(inAttribute);
    }

    public static Document parseBodyFragmentRelaxed(String bodyHtml, String baseUri) {
        return Parser.parse(bodyHtml, baseUri);
    }

    public static Parser htmlParser() {
        return new Parser(new HtmlTreeBuilder());
    }

    public static Parser xmlParser() {
        return new Parser(new XmlTreeBuilder());
    }
}

