/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.jsoup.parser;

import java.util.Iterator;
import java.util.List;
import leap.lang.jsoup.helper.Validate;
import leap.lang.jsoup.nodes.Comment;
import leap.lang.jsoup.nodes.DocumentType;
import leap.lang.jsoup.nodes.Element;
import leap.lang.jsoup.nodes.Node;
import leap.lang.jsoup.nodes.TextNode;
import leap.lang.jsoup.nodes.XmlDeclaration;
import leap.lang.jsoup.parser.ParseErrorList;
import leap.lang.jsoup.parser.Tag;
import leap.lang.jsoup.parser.Token;
import leap.lang.jsoup.parser.TreeBuilder;

public class XmlTreeBuilder
extends TreeBuilder {
    @Override
    protected void initialiseParse(String input, String baseUri, ParseErrorList errors) {
        super.initialiseParse(input, baseUri, errors);
        this.stack.add(this.doc);
    }

    @Override
    protected boolean process(Token token) {
        switch (token.type) {
            case StartTag: {
                this.insert(token.asStartTag());
                break;
            }
            case EndTag: {
                this.popStackToClose(token.asEndTag());
                break;
            }
            case Comment: {
                this.insert(token.asComment());
                break;
            }
            case Character: {
                this.insert(token.asCharacter());
                break;
            }
            case Doctype: {
                this.insert(token.asDoctype());
                break;
            }
            case EOF: {
                break;
            }
            default: {
                Validate.fail("Unexpected token type: " + (Object)((Object)token.type));
            }
        }
        return true;
    }

    private void insertNode(Node node) {
        this.currentElement().appendChild(node);
    }

    Element insert(Token.StartTag startTag) {
        Tag tag = Tag.valueOf(startTag.name());
        Element el = new Element(tag, this.baseUri, startTag.attributes);
        this.insertNode(el);
        if (startTag.isSelfClosing()) {
            this.tokeniser.acknowledgeSelfClosingFlag();
            if (!tag.isKnownTag()) {
                tag.setSelfClosing();
            }
        } else {
            this.stack.add(el);
        }
        return el;
    }

    void insert(Token.Comment commentToken) {
        String data;
        Comment comment;
        Node insert = comment = new Comment(commentToken.getData(), this.baseUri);
        if (commentToken.bogus && (data = comment.getData()).length() > 1 && (data.startsWith("!") || data.startsWith("?"))) {
            String declaration = data.substring(1);
            insert = new XmlDeclaration(declaration, comment.baseUri(), data.startsWith("!"));
        }
        this.insertNode(insert);
    }

    void insert(Token.Character characterToken) {
        TextNode node = new TextNode(characterToken.getData(), this.baseUri);
        this.insertNode(node);
    }

    void insert(Token.Doctype d) {
        DocumentType doctypeNode = new DocumentType(d.getDeclaration(), d.getName(), d.getPublicIdentifier(), d.getSystemIdentifier(), this.baseUri);
        this.insertNode(doctypeNode);
    }

    private void popStackToClose(Token.EndTag endTag) {
        Element next;
        String elName = endTag.name();
        Element firstFound = null;
        Iterator it = this.stack.descendingIterator();
        while (it.hasNext()) {
            next = (Element)it.next();
            if (!next.nodeName().equals(elName)) continue;
            firstFound = next;
            break;
        }
        if (firstFound == null) {
            return;
        }
        it = this.stack.descendingIterator();
        while (it.hasNext()) {
            next = (Element)it.next();
            if (next == firstFound) {
                it.remove();
                break;
            }
            it.remove();
        }
    }

    List<Node> parseFragment(String inputFragment, String baseUri, ParseErrorList errors) {
        this.initialiseParse(inputFragment, baseUri, errors);
        this.runParser();
        return this.doc.childNodes();
    }
}

