/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.jsoup.select;

import java.util.Collection;
import java.util.LinkedHashSet;
import leap.lang.jsoup.helper.Validate;
import leap.lang.jsoup.nodes.Element;
import leap.lang.jsoup.select.Collector;
import leap.lang.jsoup.select.Elements;
import leap.lang.jsoup.select.Evaluator;
import leap.lang.jsoup.select.QueryParser;

public class Selector {
    private final Evaluator evaluator;
    private final Element root;

    private Selector(String query, Element root) {
        Validate.notNull(query);
        query = query.trim();
        Validate.notEmpty(query);
        Validate.notNull(root);
        this.evaluator = QueryParser.parse(query);
        this.root = root;
    }

    public static Elements select(String query, Element root) {
        return new Selector(query, root).select();
    }

    public static Elements select(String query, Iterable<Element> roots) {
        Validate.notEmpty(query);
        Validate.notNull(roots);
        LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
        for (Element root : roots) {
            elements.addAll(Selector.select(query, root));
        }
        return new Elements(elements);
    }

    private Elements select() {
        return Collector.collect(this.evaluator, this.root);
    }

    static Elements filterOut(Collection<Element> elements, Collection<Element> outs) {
        Elements output = new Elements();
        for (Element el : elements) {
            boolean found = false;
            for (Element out : outs) {
                if (!el.equals(out)) continue;
                found = true;
                break;
            }
            if (found) continue;
            output.add(el);
        }
        return output;
    }

    public static class SelectorParseException
    extends IllegalStateException {
        public SelectorParseException(String msg, Object ... params) {
            super(String.format(msg, params));
        }
    }
}

